/*
* PndLLbarAnaTask.cxx
*
*  Created on: July 7, 2015
*  Author: Walter Ikegami Andersson
*/

// The header file
#include "TimingTestsTask.h"

#include <string>
#include <iostream>

// FAIR headers
#include "FairRootManager.h"
#include "FairRunAna.h"
#include "FairRuntimeDb.h"
#include "FairRun.h"
#include "FairRuntimeDb.h"

#include "FairEventHeader.h"

// ROOT headers
#include "TClonesArray.h"
#include "TLorentzVector.h"
#include "TVector3.h"
#include "TH1F.h"
#include "TH2F.h"
#include "TParticlePDG.h"

#include "PndSttHit.h"

// Analysis headers
#include "PndAnalysis.h"
#include "Pnd4CFitter.h"
#include "PndKinVtxFitter.h"
#include "PndKinFitter.h"
#include "PndVtxPoca.h"

#include "PndDecayTreeFitter.h"
		
#include "RhoTools/RhoPdtLoader.h"
using std::cout;
using std::endl;


// -----   Default constructor   -------------------------------------------
TimingTestsTask::TimingTestsTask() :
  FairTask("TimingTestsTask") {
  fEventHeader = NULL;
}
// -------------------------------------------------------------------------


// -----   Destructor   ----------------------------------------------------
TimingTestsTask::~TimingTestsTask() { }
// -------------------------------------------------------------------------




// -----   Public method Init   --------------------------------------------
InitStatus TimingTestsTask::Init() 
{		
  FairRootManager *ioManager = FairRootManager::Instance();

  if(!ioManager) {
    std::cout << "-E- TimingTestsTask::Init: "
        << "RootManager not instantiated!" << std::endl;
    return kFATAL;
  }

  fEventHeader = (TClonesArray*) ioManager->GetObject("EventHeader.");
  if(!fEventHeader) {
    cout << "-W-  TimingTestsTask::Init: No EventHeader array!"
         << endl;
    return kERROR;
  }

  fSTTHits = (TClonesArray*) ioManager->GetObject("STTHit");
  if(!fSTTHits) {
    cout << "-W-  TimingTestsTask::Init: STTHits not instantiated!" <<endl;
    return kERROR;
  }

  fStopFunctor = new StopTime();

  this->InitSpectra();

  nevts = 0;

  cout<<"TimingTestsTask - Initalization successful!"<<endl;
	return kSUCCESS;
}//End PndLLbarAnaTask::Init()

// -------------------------------------------------------------------------
	
void TimingTestsTask::SetParContainers() 
{
  // Get run and runtime database
  FairRun* run = FairRun::Instance();
  if ( ! run ) Fatal("SetParContainers", "No analysis run");
}

// -------------------------------------------------------------------------


// -----   Public method Exec   --------------------------------------------
void TimingTestsTask::Exec(Option_t* opt)
{
	FairEventHeader *myEventHeader = (FairEventHeader*) fEventHeader;
	Int_t iEvent = myEventHeader->GetMCEntryNumber();

	FairRootManager *ioManager = FairRootManager::Instance();
  if (FairRunAna::Instance()->IsTimeStamp()) {
    Double_t eventTime = ioManager->GetEventTime();
    Double_t eventTimeHdr = myEventHeader->GetEventTime();
    cout << "Event time: " << eventTime << "     Event time header: " << eventTimeHdr << endl;
    fSTTSortedHits = ioManager->GetData("STTSortedHits",fStopFunctor,eventTime+10);
  }

	PndSttHit sttHit;
	Float_t timeStamp;
	Float_t minTime = 999999;
	Float_t maxTime = 0.0001;
	Int_t nSTTHits = fSTTHits->GetEntriesFast();
	Int_t nSTTSortedHits = fSTTSortedHits->GetEntriesFast();
	for (int iHit = 0; iHit < fSTTSortedHits->GetEntriesFast(); ++iHit) {
	  sttHit = *(PndSttHit*) fSTTSortedHits->At(iHit);
	  timeStamp = sttHit.GetTimeStamp();
	  if (minTime > timeStamp) minTime = timeStamp;
	  if (maxTime < timeStamp) maxTime = timeStamp;

	  hTimeStampVsEvent->Fill(timeStamp,iEvent);
  }

	cout << "event number = " << nevts<< endl;
	cout << "number of STTHits = " << nSTTHits << endl;
	cout << "number of STTSortedHits = " << nSTTSortedHits << endl;
	cout << "min time = " << minTime << endl;
	cout << "max time = " << maxTime << endl;
	cout << "---------------------------------" << endl;

	nevts++;


}	//End PndLLbarAnaTask::Exec()






void TimingTestsTask::Finish()
{	
  hTimeStampVsEvent->Write();
  hTimeStampVsEvent->SaveAs("timeStamps.pdf");
}	//End PndLLbarAnaTask::Finish()

void TimingTestsTask::InitSpectra() {
  hTimeStampVsEvent = new TH2F("TimeStampVsEvent","TimeStampVsEvent",500,0,500,10,0,9);
}

ClassImp(TimingTestsTask)
