/*
* PndLLbarAnaTask.h
*
*  Created on: July 7, 2015
*  Author: Walter Ikegami Andersson
*/

#ifndef PndLLbarAnaTask_H
#define PndLLbarAnaTask_H 1


#include "FairTask.h"
#include <map>
#include <string>
#include "TLorentzVector.h"
#include "TDatabasePDG.h"
#include "TFile.h"
#include "TTree.h"

#include "FairEventHeader.h"

#include "FairTSBufferFunctional.h"

class TClonesArray;
class TObjectArray;
class TH1F;
class TH2F;



class TimingTestsTask : public FairTask
{

 public:
	
	// ** Default constructor   
	TimingTestsTask();
	
	// ** Destructor 
	~TimingTestsTask();	

	//int SelectTruePid(PndAnalysis *ana, RhoCandList &l);
	
	// ** Virtual method Init 
	virtual InitStatus Init();
	
	// ** Virtual method Exec 
	virtual void Exec(Option_t* opt);
	
	// ** Virtual method Finish
	virtual void Finish();
	

 protected:

	
 private: 
	// *** event counter
	int nevts;	
	
	BinaryFunctor *fStopFunctor; //!

	TClonesArray *fEventHeader;
	FairEventHeader *digiEventHeader;

	TClonesArray *fSTTHits;
	TClonesArray *fSTTSortedHits;


	// *** Get parameter containers
	virtual void SetParContainers();

	void InitSpectra();
	TH2F *hTimeStampVsEvent;

		
	ClassDef(TimingTestsTask,1);
  
};

#endif
