
//void My_enc_dvcs_pid(TString base="enc_gendvcs_dvcs/Panda_event_2_1_1", int nEvents = 10)
void My_enc_dvcs_pid(TString base="ALL_PANDA_HIGH_01", int nEvents = 100)
{

  // -----   Timer   --------------------------------------------------------
  TStopwatch timer;
  timer.Start();
  
  // ========================================================================
  // Verbosity level (0=quiet, 1=event level, 2=track level, 3=debug)
  Int_t iVerbose = 0;  
  
  // ----  Load libraries   -------------------------------------------------
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/rootlogon.C");  
  rootlogon(); 

  // ----------------------------------------------------------------------
  // Set of input file directory
  //base="/home/dkang/GSI/pandaroot/macro/dvcs/data/"+base;
  //base="/u/dkang/GSI/pandaroot/macro/dvcs/data/"+base; 
  //  base="/home/kang/GSI/pandaroot/macro/dvcs/run/test/"+base;
  

  // TString OutPath = "/home/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;  
   TString OutPath = "/data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;  

  TString parFile   = OutPath+"_par.root";
  TString inFile    = OutPath+"_sim.root";
  TString digiFile  = OutPath+"_dig.root";
  TString recoFile  = OutPath+"_rec.root";
  TString outFile   = OutPath+"_pid.root";



  // -----   Reconstruction run   -------------------------------------------
  FairRunAna *fRun= new FairRunAna();
  fRun->SetInputFile(inFile);
  fRun->AddFriend(digiFile);  
  fRun->AddFriend(recoFile);
  fRun->SetOutputFile(outFile);
  // ------------------------------------------------------------------------

  //This is needed for kalman fit!
  FairGeane *Geane = new FairGeane();
  fRun->AddTask(Geane);


  // Digitisation file (ascii) for EMC
  TString digiFile = "all_enc.par";  
  TString allDigiFile = gSystem->Getenv("VMCWORKDIR");
  allDigiFile += "/macro/params/";
  allDigiFile += digiFile;
  
  // ------------------------------------------------------------------------
  // -----  Parameter database   --------------------------------------------
  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
  FairParRootFileIo* parInput1 = new FairParRootFileIo();
  parInput1->open(parFile.Data());
	
  FairParAsciiFileIo* parIo1 = new FairParAsciiFileIo();
  parIo1->open(allDigiFile.Data(),"in");
        
  rtdb->setFirstInput(parInput1);
  rtdb->setSecondInput(parIo1);

  
  ///////////////////////////////////////////////////////////////////////// 
  // PID ---------------------------------
  PndPidCorrelator* corr = new PndPidCorrelator();
  corr->SetVerbose(iVerbose);
  corr->SetInputBranch("LheGenTrack");
  corr->SetInputIDBranch("LheTrackID");
  corr->SetDebugMode(kFALSE);   
  //corr->SetDebugFilename(corFile.Data());
  fRun->AddTask(corr);
 
  // the associator (creates PidChargedProbaility and PidNeutralProbability TCAs)  

  PndPidIdealAssociatorTask *assMC= new PndPidIdealAssociatorTask();
  fRun->AddTask(assMC);

  PndPidMvdAssociatorTask *assMvd= new PndPidMvdAssociatorTask();
  fRun->AddTask(assMvd);

  PndPidMdtHCAssociatorTask *assMdt= new PndPidMdtHCAssociatorTask();
  fRun->AddTask(assMdt);

  PndPidDrcAssociatorTask *assDrc= new PndPidDrcAssociatorTask();
  fRun->AddTask(assDrc);

  PndPidDiscAssociatorTask *assDisc= new PndPidDiscAssociatorTask();
  fRun->AddTask(assDisc);


  PndMcListConverter *mcc=new PndMcListConverter();
  fRun->AddTask(mcc);


  // -----   Intialise and run   --------------------------------------------

  PndEmcMapper::Init(6);
  fRun->Init();  
  fRun->Run(0,nEvents);

  rtdb->print();
  
  timer.Stop();
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  cout << endl << endl;
  cout << "*** PID FINISHED ***" <<endl;
  cout << "Macro finished succesfully." << endl;
  cout << "Output file is "    << outFile << endl;
  cout << "Parameter file is " << parFile << endl;
  cout << "Real time " << rtime << " s, CPU time " << ctime << " s" << endl;
  cout << endl;
  // ------------------------------------------------------------------------

  //delete fRun;
  exit(0);  


}
