#!/bin/bash


export RUNDIR=/data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test
export BATCH=batch
export HH=/data/work/kpha4/moraespi
export JOBNAME=bh-15GeV-test01
export DATADIR=/data/work/kpha4/moraespi/EventGenerators/GenDVCS1.0/TestManyCards/data
export CARDNAME=data_bh-1000evts

beam=15.0
nevts=1000
nruns=100
i=1

while [ "$i" -le "$nruns" ]
do

    echo "   Sending run number: " $i
    
    
    macro=submit_do_$i.sh
    
    echo "#!/bin/bash" >> $macro
    echo "" >> $macro
    echo "" >> $macro
      #  echo "#PBS -q $BATCH" >> $macro
    echo "#PBS -N $JOBNAME-$i" >> $macro
    echo "#PBS -j oe" >> $macro
    echo "#PBS -o $RUNDIR/output/$JOBNAME-"$i".log" >> $macro
    echo "#PBS -l vmem=3GB,walltime=4:00:00" >> $macro
    echo "#PBS -V" >> $macro
    
    echo "" >> $macro
    echo "export PATH=\$PBS_O_PATH:$PATH" >> $macro
    echo "" >> $macro
    
    echo "root -l -q -q $RUNDIR/My_enc_dvcs_run.C'("\"$CARDNAME$i\"", "$nevts", "$beam")'">> $macro
    echo "root -l -q -q $RUNDIR/My_enc_dvcs_dig.C'("\"$CARDNAME$i\"", "$nevts")'">> $macro
    echo "root -l -q -q $RUNDIR/My_enc_dvcs_rec.C'("\"$CARDNAME$i\"", "$nevts")'">> $macro
    echo "root -l -q -q $RUNDIR/My_enc_dvcs_pid.C'("\"$CARDNAME$i\"", "$nevts")'">> $macro
    echo "root -l -q -q $RUNDIR/My_enc_dvcs_dch.C'("\"$CARDNAME$i\"", "$nevts")'">> $macro
    echo "root -l -q -q $RUNDIR/My_enc_dvcs_loc.C'("\"$CARDNAME$i\"", "$nevts")'">> $macro
    echo "root -l -q -q $RUNDIR/My_enc_dvcs_glo.C'("\"$CARDNAME$i\"", "$nevts")'">> $macro
    echo "root -l -q -q $RUNDIR/My_enc_dvcs_his.C'("\"$CARDNAME$i\"", "$nevts")'">> $macro

sleep 0.5
qsub $macro;
rm $macro; 

i=$(($i+1))

done 

echo "DONE"


#PBS -N ALL_PANDA_HIGH_02
#PBS -j oe
#PBS -o /data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/ALL_PANDA_HIGH_02.log
#PBS -l vmem=3GB,walltime=24:00:00
#PBS -V

#export PATH=$PBS_O_PATH:/home/moraespi/PandaRoot/fairsoft_enc_2015-10-12/tools/root/bin:/usr/mpi/gcc/openmpi-1.4.3/bin:/usr/local/bin:/bin:/usr/bin:/usr/local/sbin:/usr/sbin:/sbin:/usr/local/maui/bin/:/home/moraespi/bin
#
#root -l -q -b /data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/My_enc_dvcs_run.C'("data_all-1000evts", 100, 15.0)'
#root -l -q -b /data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/My_enc_dvcs_dig.C'("data_all-1000evts", 100)'
#root -l -q -b /data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/My_enc_dvcs_rec.C'("data_all-1000evts", 100)'
#root -l -q -b /data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/My_enc_dvcs_pid.C'("data_all-1000evts", 100)'
#root -l -q -b /data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/My_enc_dvcs_dch.C'("data_all-1000evts", 100)'
#root -l -q -b /data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/My_enc_dvcs_loc.C'("data_all-1000evts", 100)' 
#root -l -q -b /data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/My_enc_dvcs_glo.C'("data_all-1000evts", 100)' 
#root -l -q -b /data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/My_enc_dvcs_his.C'("data_all-1000evts", 100)' 

