
//void My_enc_dvcs_dig(TString base="enc_gendvcs_dvcs/Panda_event_2_1_1", int nEvents = 10)
void My_enc_dvcs_dig(TString base="ALL_PANDA_HIGH_01", int nEvents = 100)
{

  // -----   Timer   --------------------------------------------------------
  TStopwatch timer;
  timer.Start();

  // ========================================================================
  // Verbosity level (0=quiet, 1=event level, 2=track level, 3=debug)
  Int_t iVerbose = 0;   
  // ----  Load libraries   -------------------------------------------------
  gROOT->Macro("$VMCWORKDIR/gconfig/rootlogon.C");    
  rootlogon(); 


  // ----------------------------------------------------------------------
  //  Set of input file directory
  //base="/home/dkang/GSI/pandaroot/macro/dvcs/data/"+base;  
  //base="/u/dkang/GSI/pandaroot/macro/dvcs/data/"+base; 
  //  base="/home/kang/GSI/pandaroot/macro/dvcs/run/test/"+base;  
  //  TString OutPath = "/home/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;  
   TString OutPath = "/data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;  

  TString inFile  = OutPath+"_sim.root";
  TString parFile = OutPath+"_par.root";
  TString outFile = OutPath+"_dig.root";



  // -----  Parameter database   --------------------------------------------
  TString digiparFile = gSystem->Getenv("VMCWORKDIR");
  digiparFile += "/macro/params/all_enc.par";

 
  TString mcMode = "TGeant3";

  // -----   Reconstruction run   -------------------------------------------
  FairRunAna *fRun= new FairRunAna();
  fRun->SetInputFile(inFile);
  fRun->SetOutputFile(outFile);

  // -----  Parameter database   --------------------------------------------
  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
  FairParRootFileIo* parInput1 = new FairParRootFileIo(kTRUE);
  //parInput1->open(parFile.Data(),"UPDATE");
  parInput1->open(parFile.Data());
  
  rtdb->setFirstInput(parInput1);
  
  FairParAsciiFileIo* parInput2 = new FairParAsciiFileIo();
  parInput2->open(digiparFile.Data(),"in");
  rtdb->setSecondInput(parInput2);


 

  // -----    TPC hit producer   --------------------------------------------
  PndTpcClusterizerTask* tpcClusterizer = new PndTpcClusterizerTask();
  if(mcMode=="TGeant3") tpcClusterizer->SetMereChargeConversion();  
  //tpcClusterizer->SetPersistence();
  fRun->AddTask(tpcClusterizer);
 
  PndTpcDriftTask* tpcDrifter = new PndTpcDriftTask();
  // tpcDrifter->SetPersistence();
  tpcDrifter->SetDistort(false);
  fRun->AddTask(tpcDrifter);

  PndTpcGemTask* tpcGem = new PndTpcGemTask();
  //tpcGem->SetPersistence();
  fRun->AddTask(tpcGem);

  PndTpcPadResponseTask* tpcPadResponse = new PndTpcPadResponseTask();
  tpcPadResponse->SetPersistence();
  //tpcPadResponse->SetQAPlotCol(qa);
  fRun->AddTask(tpcPadResponse);

  PndTpcElectronicsTask* tpcElec = new PndTpcElectronicsTask();
  //tpcElec->SetPersistence(); 
  //tpcElec->SetQAPlotCol(qa)
  fRun->AddTask(tpcElec);

  PndTpcClusterFinderTask* tpcCF = new PndTpcClusterFinderTask();
  tpcCF->SetPersistence();
  tpcCF->timeslice(20); // = 4 sample times = 100ns @ 40MHz
  //
  // Following three lines added on request by Felix, 20/02/2011
  //
  tpcCF->SetMode(1);
  tpcCF->SetDiffFactor(1.3);
  tpcCF->SetErrorPars(600,300);
  fRun->AddTask(tpcCF);
  


  
 

  // -----   new MVD hit producer   ---------------------------------------
  PndMvdDigiTask* mvddigi = new PndMvdDigiTask();
  mvddigi->SetVerbose(iVerbose);
  fRun->AddTask(mvddigi);

  PndMvdClusterTask* mvdmccls = new PndMvdClusterTask();
  mvdmccls->SetVerbose(iVerbose);
  fRun->AddTask(mvdmccls); 
 
 
   //---------------------Create and Set the Field(s)----------  
  //EMC part       
  PndEmcHitsToWaveform* emcHitsToWaveform= new PndEmcHitsToWaveform(0);
  PndEmcWaveformToDigi* emcWaveformToDigi=new PndEmcWaveformToDigi(0);
  emcHitsToWaveform->SetStorageOfData(kFALSE);
  emcWaveformToDigi->SetStorageOfData(kFALSE);
  fRun->AddTask(emcHitsToWaveform);  // full digitization
  fRun->AddTask(emcWaveformToDigi);  // full digitization
 
  PndEmcMakeCluster* emcMakeCluster= new PndEmcMakeCluster(0);
  //emcMakeCluster->SetStorageOfData(kFALSE);
  fRun->AddTask(emcMakeCluster);

  PndEmcHdrFiller* emcHdrFiller = new PndEmcHdrFiller();
  fRun->AddTask(emcHdrFiller); // ECM header

  PndEmcMakeBump* emcMakeBump= new PndEmcMakeBump();
  //emcMakeBump->SetStorageOfData(kFALSE);
  fRun->AddTask(emcMakeBump);

  PndEmcMakeRecoHit* emcMakeRecoHit= new PndEmcMakeRecoHit();
  fRun->AddTask(emcMakeRecoHit);  
  
 
 
 
 
  
  // -----   TOF hit producers   ---------------------------------
  PndTofHitProducerIdeal* tofhit = new PndTofHitProducerIdeal();
  tofhit->SetVerbose(iVerbose);
  fRun->AddTask(tofhit);
 
  // -----   MDT hit producers   ---------------------------------
  PndMdtHitProducerIdeal* mdtHitProd = new PndMdtHitProducerIdeal();
  mdtHitProd->SetPositionSmearing(.3); // position smearing [cm]
  fRun->AddTask(mdtHitProd);
  
  PndMdtTrkProducer* mdtTrkProd = new PndMdtTrkProducer();
  fRun->AddTask(mdtTrkProd);

  // -----   DRC hit producers   ---------------------------------
  PndDrcHitProducerIdeal* drchit = new PndDrcHitProducerIdeal();
  drchit->SetVerbose(iVerbose);
  fRun->AddTask(drchit);


  // -----   GEM hit producers   ---------------------------------  
  Int_t verboseLevel = 0;
  PndGemDigitize* gemDigitize = new PndGemDigitize("GEM Digitizer", verboseLevel);
  fRun->AddTask(gemDigitize);

  PndGemFindHits* gemFindHits = new PndGemFindHits("GEM Hit Finder", verboseLevel);
  fRun->AddTask(gemFindHits);	

  



  // -----   Intialise and run   --------------------------------------------
  fRun->Init();
  fRun->Run(0,nEvents);
  rtdb->saveOutput();
  rtdb->print();

  // -----   Finish   -------------------------------------------------------
  timer.Stop();
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  cout << endl << endl;
  cout << "*** DIG FINISHED ***" <<endl;
  cout << "Macro finished succesfully." << endl;
  cout << "Output file is "    << outFile << endl;
  cout << "Parameter file is " << parFile << endl;
  cout << "Real time " << rtime << " s, CPU time " << ctime << " s\a\a" << endl;
  cout << endl;

  exit(0);

}
