
//void My_enc_dvcs_run(TString base="enc_gendvcs_dvcs/Panda_event_2_1_1", int nEvents = 10)
void My_enc_dvcs_run(TString base="data_all-1000evts2", int nEvents = 100, double pMom=15.0, int run=1)
{

  TStopwatch timer;
  timer.Start();
  gDebug=0;
  int verboseLevel = 0;


  // Load basic libraries
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/rootlogon.C");
  rootlogon(); 


  FairRunSim *fRun = new FairRunSim();


  // set the MC version used
  // ------------------------
  fRun->SetName("TGeant3");



  // ----------------------------------------------------------------------
  // Set of input file directory 
  // Input file (Ascii)
  //base="/home/dkang/GSI/pandaroot/macro/dvcs/data/"+base; 
  //base="/u/dkang/GSI/pandaroot/macro/dvcs/data/"+base; 
  //base="/home/kang/GSI/pandaroot/macro/dvcs/run/test/"+base; 
   TString base2="/data/work/kpha4/moraespi/EventGenerators/GenDVCS1.0/TestManyCards/data/"+base;
    TString OutPath = "/data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;  
 
  //  base="/home/moraespi/PandaRoot/pandaroot_enc_2015-10-12/macro/encrun/Donghee_last_macros"+base;

  TString inFile   = base2+".ascii";
  TString parFile  = OutPath+"_par.root";
  TString outFile  = OutPath+"_sim.root";

  
  fRun->SetOutputFile(outFile.Data());

  

  
  // Set the parameters
  //-------------------------------
  TString allDigiFile = gSystem->Getenv("VMCWORKDIR");
  allDigiFile += "/macro/params/all_enc.par";
 
  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
  FairParAsciiFileIo* parIo1 = new FairParAsciiFileIo();
  parIo1->open(allDigiFile.Data(),"in");
  rtdb->setFirstInput(parIo1);        
  Bool_t kParameterMerged=kTRUE;
	
  FairParRootFileIo* output=new FairParRootFileIo(kParameterMerged);
  output->open(parFile);
  rtdb->setOutput(output);
  

  // Set Material file Name
  //-----------------------

  fRun->SetMaterials("media_pnd.geo");
  
  // Create and add detectors
  //-------------------------
  
  FairModule *Cave= new PndCave("CAVE");
  Cave->SetGeometryFileName("pndcave.geo");
  fRun->AddModule(Cave); 
  
  FairModule *Magnet= new PndMagnet("MAGNET");
  Magnet->SetGeometryFileName("FullSolenoid.root");//magnet.geo or FullSolenoid.root
  //Magnet->SetGeometryFileName("FullSuperconductingSolenoid_v831.root");
  fRun->AddModule(Magnet);  

  FairModule *Dipole= new PndMagnet("MAGNET");
  Dipole->SetGeometryFileName("dipole.geo");
  fRun->AddModule(Dipole); 
  

  FairModule *Pipe= new PndPipe("PIPE");//For enc this is an inner extra dipole
  fRun->AddModule(Pipe);
  
   
  PndTpcDetector *PndTpc = new PndTpcDetector("TPC", kTRUE);
  PndTpc->SetGeometryFileName("tpc.geo");
  fRun->AddModule(PndTpc);
  

  FairDetector *Mvd = new PndMvdDetector("MVD", kTRUE);
  Mvd->SetGeometryFileName("EIC_MVD_z300.root");//30cm
  Mvd->SetVerboseLevel(verboseLevel);
  fRun->AddModule(Mvd);


  PndEmc *Emc = new PndEmc("EMC",kTRUE);
  Emc->SetGeometryVersion(15); 
  Emc->SetStorageOfData(kFALSE);
  fRun->AddModule(Emc);  

  FairDetector *Tof = new PndTof("TOF",kTRUE);
  Tof->SetGeometryFileName("tofbarrel.geo");
  fRun->AddModule(Tof);


  PndMdt *Muo = new PndMdt("MDT",kTRUE);
  Muo->SetBarrel("fast");
  Muo->SetEndcap("fast");
  Muo->SetMuonFilter("fast");
  Muo->SetMdtMagnet(kTRUE);
  Muo->SetMdtMFIron(kTRUE);
  fRun->AddModule(Muo);   
  
  FairDetector *Gem = new PndGemDetector("GEM", kTRUE);
  Gem->SetGeometryFileName("gem_4Stations_enc2.root");
  fRun->AddModule(Gem);

  PndDrc *Drc = new PndDrc("DIRC", kTRUE);
  Drc->SetRunCherenkov(kTRUE); // for fast sim Cherenkov -> kFALSE
  fRun->AddModule(Drc);

  
  PndDsk* Dsk = new PndDsk("DSK", kTRUE);
  Dsk->SetGeometryFileName("dsk.root");
  Dsk->SetStoreCerenkovs(kFALSE);
  Dsk->SetStoreTrackPoints(kFALSE);
  fRun->AddModule(Dsk);

  FairDetector *Dch = new PndDchDetector("DCH", kTRUE);
  Dch->SetGeometryFileName("dch_worich_enc.root"); 
  Dch->SetVerboseLevel(0);
  fRun->AddModule(Dch);
  
    
  // Create and Set Event Generator
  //-------------------------------

  FairPrimaryGenerator* primGen = new FairPrimaryGenerator();
  fRun->SetGenerator(primGen);

  PndPythia6Generator* pygen=new PndPythia6Generator(inFile.Data());
  primGen->AddGenerator(pygen); 

  primGen->SetTarget(30., 0);//SetTarget(targetZ, targetDz);  [cm] z=-10  0(center)  10
  //primGen->SetBeam(0, 0, 0.02, 0.02);//SetBeam(beamX0, beamY0, beamSigmaX, beamSigmaY); for x and y
  //primGen->SmearVertexZ(kTRUE);
  //primGen->SmearVertexXY(kTRUE); 



  // Create and Set Event Generator
  //-------------------------------
/*  FairPrimaryGenerator* primGen = new FairPrimaryGenerator();
  fRun->SetGenerator(primGen);
  //e-    
  FairBoxGenerator *fBox = new FairBoxGenerator(2212, 1);
  fBox->SetPRange(10, 15);
  fBox->SetPhiRange(0.,360);  
  fBox->SetThetaRange(0, 20);
  fBox->SetXYZ(0., 0., 30.); // vertex coordinates [cm]
  primGen->AddGenerator(fBox);
*/



  //---------------------Create and Set the Field(s)----------  
  fRun->SetBeamMom(pMom);	
  
  PndMultiField *fField= new PndMultiField("FULL");
  fRun->SetField(fField);
  fRun->SetStoreTraj(kFALSE);
  fRun->SetRadLenRegister(kFALSE);
  
  PndEmcHitProducer* emcHitProd = new PndEmcHitProducer();
  fRun->AddTask(emcHitProd);
 

  /*
  PndMultiFieldPar* Par = (PndMultiFieldPar*) rtdb->getContainer("PndMultiFieldPar");
  if (fField) {  Par->SetParameters(fField); }
  Par->setInputVersion(fRun->GetRunId(),1);
  Par->setChanged();
  */ 
 
 
 
 
  /**Initialize the session*/ 
  fRun->Init();   
    

  rtdb->setOutput(output);
  rtdb->saveOutput();
  rtdb->print();




  fRun->Run(nEvents);


  
  // Transport nEvents
  // -----------------  
  timer.Stop();
   
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  cout<<"*** RUN FINISHED ***"<<endl;
  printf("RealTime=%f seconds, CpuTime=%f seconds\n",rtime,ctime);

  exit(0);  

}  
  
