
//void My_enc_dvcs_rec(TString base="enc_gendvcs_dvcs/Panda_event_2_1_1", int nEvents = 10)
void My_enc_dvcs_rec(TString base="ALL_PANDA_HIGH_01", int nEvents = 100)
{

  // -----   Timer   --------------------------------------------------------
  TStopwatch timer;
  timer.Start();
  
  // ========================================================================
  // Verbosity level (0=quiet, 1=event level, 2=track level, 3=debug)
  Int_t iVerbose = 0;  
  
  // ----  Load libraries   -------------------------------------------------
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/rootlogon.C");  
  rootlogon(); 

  // ----------------------------------------------------------------------
  // Set of input file directory
  // Input file  
  //base="/home/dkang/GSI/pandaroot/macro/dvcs/data/"+base;  
  //base="/u/dkang/GSI/pandaroot/macro/dvcs/data/"+base; 
  //  base="/home/kang/GSI/pandaroot/macro/dvcs/run/test/"+base;  

   TString OutPath = "/data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;   
   //   TString OutPath = "/home/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;  

  TString digiFile = OutPath+"_dig.root";
  TString inFile   = OutPath+"_sim.root";
  TString parFile  = OutPath+"_par.root";
  TString outFile  = OutPath+"_rec.root";


   




  // -----   Reconstruction run   -------------------------------------------
  FairRunAna *fRun= new FairRunAna();
  fRun->SetInputFile(inFile);
  fRun->AddFriend(digiFile);
  fRun->SetOutputFile(outFile);
  // ------------------------------------------------------------------------

  //This is needed for kalman fit!
  FairGeane *Geane = new FairGeane();
  fRun->AddTask(Geane);


  // Digitisation file (ascii) for EMC
  TString digiFile = "all_enc.par";  
  TString allDigiFile = gSystem->Getenv("VMCWORKDIR");
  allDigiFile += "/macro/params/";
  allDigiFile += digiFile;
  
  // ------------------------------------------------------------------------
  // -----  Parameter database   --------------------------------------------
  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
  FairParRootFileIo* parInput1 = new FairParRootFileIo();
  parInput1->open(parFile.Data());
	
  FairParAsciiFileIo* parIo1 = new FairParAsciiFileIo();
  parIo1->open(allDigiFile.Data(),"in");
        
  rtdb->setFirstInput(parInput1);
  rtdb->setSecondInput(parIo1);
  PndGeoHandling* geoH = PndGeoHandling::Instance();//only in reco???

  ///////////////////////////////////////////////////////////////////////// 
  // -----   LHETRACK  ---------------------------------
  PndLheHitsMaker* trackMS = new PndLheHitsMaker("Tracking routine");
  trackMS->SetTpcMode(2);  // 0 OFF, 1 TpcPoint, 2 TpcCluster // TpcPoint smearing [cm], if negative no smearing   
  //trackMS->SetSttMode(3);  // 0 OFF, 1 SttPoint, 2 SttHit, (3) SttHelixHit // SttPoint smearing [cm], if negative no smearing
  trackMS->SetMvdMode(2);  // 0 OFF, 1 MVDPoint, 2 MVDHit     // MVDPoint smearing [cm], if negative no smearing
  trackMS->SetGemMode(2);  // 0 OFF, 1 GEMPoint, 2 GEMHit     // GEMPoint smearing [cm], if negative no
  trackMS->SetVerbose(0);
  fRun->AddTask(trackMS);

  PndLheTrackFinder* trackFinder    = new PndLheTrackFinder();
  //PndLheTrackFinderIdeal* trackFinder    = new PndLheTrackFinderIdeal();
  trackFinder->SetVerbose(iVerbose);
  fRun->AddTask(trackFinder);

  PndLheTrackFitter* trackFitter    = new PndLheTrackFitter("fitting");
  trackFitter->SetVerbose(iVerbose);
  fRun->AddTask(trackFitter);


  PndRecoKalmanTask* recoKalman = new PndRecoKalmanTask();
  recoKalman->SetParticleHypo("e");
  recoKalman->SetTrackInBranchName("LheTrack");
  recoKalman->SetTrackOutBranchName("LheGenTrack");
  fRun->AddTask(recoKalman);
  

 
  //PndMvdGeoPar* geoPar  = (PndMvdGeoPar*)(rtdb->getContainer("PndMvdGeoPar"));
  //PndEmcMapper::Init(6);
  //PndEmcMapper *emcMap = PndEmcMapper::Instance(6,inFile);
  //Geane->SetField(fRun->GetField()); 
  
  PndEmcMapper::Init(6);
  
  fRun->Init();  
  

  fRun->Run(0,nEvents);

  rtdb->saveOutput();
  rtdb->print();
 
  timer.Stop();
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  cout << endl << endl;
  cout << "*** REC FINISHED ***" <<endl;
  cout << "Macro finished succesfully." << endl;
  cout << "Output file is "    << outFile << endl;
  cout << "Parameter file is " << parFile << endl;
  cout << "Real time " << rtime << " s, CPU time " << ctime << " s" << endl;
  cout << endl;
  // ------------------------------------------------------------------------

  exit(0);  


}
