
//void My_enc_dvcs_loc(TString base="enc_gendvcs_dvcs/Panda_event_2_1_1", int nEvents = 10)
void My_enc_dvcs_loc(TString base="ALL_PANDA_HIGH_01", int nEvents = 100)
{

  // -----   Timer   --------------------------------------------------------
  TStopwatch timer;
  timer.Start();
  
  // ========================================================================
  // Verbosity level (0=quiet, 1=event level, 2=track level, 3=debug)
  Int_t iVerbose = 0;  
  
  // ----  Load libraries   -------------------------------------------------
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/rootlogon.C");  
  rootlogon(); 

  // ----------------------------------------------------------------------
  // Set of input file directory
  //base="/home/dkang/GSI/pandaroot/macro/dvcs/data/"+base;
  //base="/u/dkang/GSI/pandaroot/macro/dvcs/data/"+base; 
  //  base="/home/kang/GSI/pandaroot/macro/dvcs/run/test/"+base;

  //  TString OutPath = "/home/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;  
   TString OutPath = "/data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;  

  TString inFile    = OutPath+"_sim.root";
  TString digiFile  = OutPath+"_dig.root";
  TString parFile   = OutPath+"_par.root";
  TString outFile   = OutPath+"_loc.root"; 
  
  
  TString digiparFile = gSystem->Getenv("VMCWORKDIR");
  digiparFile += "/macro/params/all_enc.par";
 

  // -----   Reconstruction run   -------------------------------------------
  FairRunAna *fRun= new FairRunAna();
  fRun->SetInputFile(inFile);
  fRun->AddFriend(digiFile);
  fRun->SetOutputFile(outFile);

  // ------------------------------------------------------------------------

  //This is needed for kalman fit!
  FairGeane *Geane = new FairGeane();
  fRun->AddTask(Geane);


  // -----  Parameter database   --------------------------------------------
  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
  FairParRootFileIo* parInput1 = new FairParRootFileIo(kTRUE);
  parInput1->open(parFile.Data());
  
  rtdb->setFirstInput(parInput1);
  FairParAsciiFileIo* parInput2 = new FairParAsciiFileIo();
  parInput2->open(digiparFile.Data(),"in");
  rtdb->setSecondInput(parInput2);

  /* // ACCORDING TO DONGHEE, I DON'T NEED THIS PART - BEGINNING

  // ##################################################################    MVD
  // -----   MDV digi producer   ----------------------------------------
  PndMvdDigiTask* mvddigi = new PndMvdDigiTask();
  mvddigi->SetVerbose(iVerbose);
  fRun->AddTask(mvddigi);
    // -----   MDV cluster producer   -----------------------------------
  Double_t chargecut = 5000., pixelrad=1.8; // one day this will move to the parameter db.
  PndMvdClusterTask* mvdmccls = new PndMvdClusterTask();
  mvdmccls->SetVerbose(iVerbose);
  fRun->AddTask(mvdmccls);

  
  // ##################################################################   MVD
  // -----   MVD ideal tracking  --------------------------------------------
  PndMvdIdealTrackFinderTask* mvdTrackFinder = new PndMvdIdealTrackFinderTask();
  mvdTrackFinder->SetVerbose(iVerbose);
  fRun->AddTask(mvdTrackFinder);
   
  //  ACCORDING TO DONGHEE, I DON'T NEED THIS PART - END */ 
 
  
  // ##################################################################   GEM
  // -----   GEM ideal tracking  --------------------------------------
  PndGemFindTracks* gemFinderTask = new PndGemFindTracks("PndGemFindTracks");
  gemFinderTask->SetUseHitOrDigi("hit"); // hit = (default), digi
  fRun->AddTask(gemFinderTask);

  // ------------------------------------------------------------------  
  PndGemTrackFinderIdeal* gemMcTrackFinder = new  PndGemTrackFinderIdeal();
  gemMcTrackFinder->SetVerbose(0);  // verbosity level
  gemMcTrackFinder->SetPrimary(0);  // 1 = Only primary tracks are processed, 0 = all (default)
  gemFinderTask->UseFinder(gemMcTrackFinder);
 
  // ------------------------------------------------------------------  
  //PndGemTrackFinderQA* gemTrackFinderQA = new PndGemTrackFinderQA();
  //gemTrackFinderQA->SetVerbose(0);
  //fRun->AddTask(gemTrackFinderQA); 
  


 
  fRun->Init();  
  fRun->Run(0,nEvents);

  cout<<""<<endl;
  cout<<"*********************"<<endl;
  cout<<"*  HELLO, I'M HERE  *" <<endl;
  cout<<"*********************"<<endl;
  cout<<""<<endl;

  timer.Stop();
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  cout << endl << endl;
  cout << "*** LOC FINISHED ***" <<endl;
  cout << "Macro finished succesfully." << endl;
  cout << "Output file is "    << outFile << endl;
  cout << "Parameter file is " << parFile << endl;
  cout << "Real time " << rtime << " s, CPU time " << ctime << " s" << endl;
  cout << endl;
  // ------------------------------------------------------------------------

  exit(0);  


}
