
//void My_enc_dvcs_glo(TString base="enc_gendvcs_dvcs/Panda_event_2_1_1", int nEvents = 10)
void My_enc_dvcs_glo(TString base="ALL_PANDA_HIGH_01", int nEvents = 100)
{

  // -----   Timer   --------------------------------------------------------
  TStopwatch timer;
  timer.Start();
  
  // ========================================================================
  // Verbosity level (0=quiet, 1=event level, 2=track level, 3=debug)
  Int_t iVerbose = 0;  
  
  // ----  Load libraries   -------------------------------------------------
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/rootlogon.C");  
  rootlogon(); 

  // ----------------------------------------------------------------------
  // Set of input file directory
  //base="/home/dkang/GSI/pandaroot/macro/dvcs/data/"+base;
  //base="/u/dkang/GSI/pandaroot/macro/dvcs/data/"+base; 
  //  base="/home/kang/GSI/pandaroot/macro/dvcs/run/test/"+base;
  //   TString OutPath = "/home/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;  
 
   TString OutPath = "/data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;  
  // Output file reco  
  TString inFile    = OutPath+"_sim.root";
  TString digiFile  = OutPath+"_dig.root";  
  TString parFile   = OutPath+"_par.root";
  TString localFile = OutPath+"_loc.root";   
  TString dchFile   = OutPath+"_dch.root";
  TString outFile   = OutPath+"_glo.root"; 




  TString digiparFile = gSystem->Getenv("VMCWORKDIR");
  digiparFile += "/macro/params/all_enc.par";


  // -----   Reconstruction run   -------------------------------------------
  FairRunAna *fRun= new FairRunAna();  
  fRun->SetInputFile(localFile);
  fRun->AddFriend(inFile);
  fRun->AddFriend(digiFile);
  fRun->AddFriend(dchFile);

  fRun->SetOutputFile(outFile);
  // ------------------------------------------------------------------------

  //This is needed for kalman fit!
  FairGeane *Geane = new FairGeane();
  fRun->AddTask(Geane);



  // -----  Parameter database   --------------------------------------------
  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
  FairParRootFileIo* parInput1 = new FairParRootFileIo(kTRUE);
  parInput1->open(parFile.Data());
  
  rtdb->setFirstInput(parInput1);
  FairParAsciiFileIo* parInput2 = new FairParAsciiFileIo();
  parInput2->open(digiparFile.Data(),"in");
  rtdb->setSecondInput(parInput2);
  PndGeoHandling* geoH = PndGeoHandling::Instance();//only in reco???


   //-----   Run global merge   --------------------------------------------
  PndGlobalIdealTrackMerger* trackMerger = new PndGlobalIdealTrackMerger(iVerbose);
  trackMerger->UseMvdSttTpcGemDch(kTRUE,kFALSE,kFALSE,kTRUE,kTRUE);
  fRun->AddTask(trackMerger);

  //PndGlobalTrackMergerQA* trackMergerQA = new PndGlobalTrackMergerQA(iVerbose);
  //fRun->AddTask(trackMergerQA);
  
  
  //-----   Run Kalman fitter   --------------------------------------------
  PndRecoKalmanTask* recoKalman = new PndRecoKalmanTask();  
  recoKalman->SetParticleHypo("p");
  recoKalman->SetTrackInBranchName("GlobalTrack");
  recoKalman->SetTrackOutBranchName("GlobalFitTrack");
  //recoKalman->SetNumIterations(3);
  fRun->AddTask(recoKalman);

  //PndGlobalTrackFitQA* trackFitQA = new PndGlobalTrackFitQA(0);
  //fRun->AddTask(trackFitQA);

 
 
 
 
 
  
  fRun->Init();  
  fRun->Run(0,nEvents);

 
  timer.Stop();
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  cout << endl << endl;
  cout << "*** GLO FINISHED ***" <<endl;
  cout << "Macro finished succesfully." << endl;
  cout << "Output file is "    << outFile << endl;
  cout << "Parameter file is " << parFile << endl;
  cout << "Real time " << rtime << " s, CPU time " << ctime << " s" << endl;
  cout << endl;
  // ------------------------------------------------------------------------

  exit(0);  


}
