
//void My_enc_dvcs_dch(TString base="enc_gendvcs_dvcs/Panda_event_2_1_1", int nEvents = 10)
void My_enc_dvcs_dch(TString base="ALL_PANDA_HIGH_01", int nEvents = 100)
{

  // -----   Timer   --------------------------------------------------------
  TStopwatch timer;
  timer.Start();

  // ========================================================================
  // Verbosity level (0=quiet, 1=event level, 2=track level, 3=debug)
  Int_t iVerbose = 0;   
  // ----  Load libraries   -------------------------------------------------
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/rootlogon.C");    
  rootlogon();   


  // ----------------------------------------------------------------------
  //  Set of input file directory
  //base="/home/dkang/GSI/pandaroot/macro/dvcs/data/"+base;
  //base="/u/dkang/GSI/pandaroot/macro/dvcs/data/"+base; 
  //  base="/home/kang/GSI/pandaroot/macro/dvcs/run/test/"+base;
  //TString OutPath = "/home/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;  
   TString OutPath = "/data/work/kpha4/moraespi/PandaRoot/pandaroot_enc_2015-10-27/macro/dvcs/run/test/output/"+base;  

  // MV file
  TString inFile =  OutPath+"_sim.root";  
  TString parFile = OutPath+"_par.root";
  TString outFile = OutPath+"_dch.root";


  TString digiparFile = gSystem->Getenv("VMCWORKDIR");
  digiparFile += "/macro/params/all_enc.par";

 

  // -----   Reconstruction run   -------------------------------------------
  FairRunAna *fRun= new FairRunAna();
  fRun->SetInputFile(inFile);
  fRun->SetOutputFile(outFile);

  //This is needed for kalman fit!
  FairGeane *Geane = new FairGeane();
  fRun->AddTask(Geane);

  // -----  Parameter database   --------------------------------------------
  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
  FairParRootFileIo* parInput1 = new FairParRootFileIo(kTRUE);
  parInput1->open(parFile.Data());  
  
  rtdb->setFirstInput(parInput1);
  FairParAsciiFileIo* parInput2 = new FairParAsciiFileIo();
  parInput2->open(digiparFile.Data(),"in");
  rtdb->setSecondInput(parInput2);



  // -----   DCH digi producer   --------------------------------------
  PndDchDigiProducer* digiProducer= new PndDchDigiProducer();
  fRun->AddTask(digiProducer);




  // -----   DCH hit producer   ---------------------------------------
/*
  PndDchIdealHitProducer* cylHitProducer= new PndDchIdealHitProducer();
  cylHitProducer->SetVerbose(0);
  fRun->AddTask(cylHitProducer);
  PndDchFindTracks* finderTask = new PndDchFindTracks("dchFindTracks");
  finderTask->SetUseHitOrDigi("hit");//hit or chit care with below!!!
  finderTask->SetVerbose(5);
  fRun->AddTask(finderTask); 
  PndDchTrackFinderIdeal* mcTrackFinder = new  PndDchTrackFinderIdeal();
  mcTrackFinder->SetVerbose(3);  
  mcTrackFinder->SetPrimary(0);  // 1 = Only primary tracks are processed, 0 = all (default)
  finderTask->UseFinder(mcTrackFinder); 
*/ 
  // -----   DCH cylinder  hit producer   ---------------------------------------
  PndDchCylinderHitProducer* cylHitProducer= new PndDchCylinderHitProducer();
  cylHitProducer->SetVerbose(1);
  fRun->AddTask(cylHitProducer); 
  PndDchFindTracks* finderTask = new PndDchFindTracks("dchFindTracks");
  finderTask->SetUseHitOrDigi("chit");//hit or chit care with below!!!
  finderTask->SetVerbose(0);
  fRun->AddTask(finderTask);   
  PndDchTrackFinderIdealCylHit* mcTrackFinder = new  PndDchTrackFinderIdealCylHit();
  mcTrackFinder->SetVerbose(0);  
  mcTrackFinder->SetPrimary(0);  // 1 = Only primary tracks are processed, 0 = all (default)
  finderTask->UseFinder(mcTrackFinder); 
 

  //--------------------------------------------------
  //PndDchMatchTracks *matchTask = new PndDchMatchTracks();//match PndDchTracks and MCTracks
  //matchTask->SetUseHitOrDigi("chit");
  //matchTask->SetVerbose(1);
  //fRun->AddTask(matchTask);
   
  //PndDchPreFitterTR* dchPreFitter = new PndDchPreFitterTR();
  //dchPreFitter->SetVerbose(2);
  //fRun->AddTask(dchPreFitter); 
  // ------------------------------------------------- 
  //PndDchPreFitterTRQATask* dchPreFitterQA = new PndDchPreFitterTRQATask();
  //dchPreFitterQA->SetVerbose(0);
  //fRun->AddTask(dchPreFitterQA);

  //------ Kalman Tracks --------------------- 
  PndDchPrepareKalmanTracks2 *dchprepareKalmanTracks = new PndDchPrepareKalmanTracks2();
  dchprepareKalmanTracks->SetVerbose(0);
  dchprepareKalmanTracks->UseGeane(kTRUE);
  dchprepareKalmanTracks->UseMC(kTRUE);//Please trun on!!1
  dchprepareKalmanTracks->SetPDG(2212);
  dchprepareKalmanTracks->SetPersistence();
  fRun->AddTask(dchprepareKalmanTracks);

  PndDchKalmanTask2* dchKalman = new PndDchKalmanTask2();
  dchKalman->SetVerbose(0);
  dchKalman->SetNumIterations(3);
  fRun->AddTask(dchKalman);
  
  // ------------------------------------------------- 
  PndDchKalmanQATask* dchKalmanQA = new PndDchKalmanQATask();
  dchKalmanQA->SetVerbose(0);
  //dchKalmanQA->SetApproach(1);
  //dchKalmanQA->ApplySignPatch(kFALSE);
  fRun->AddTask(dchKalmanQA);




  // -----   Intialise and run   --------------------------------------------
  fRun->Init();
  fRun->Run(0,nEvents);

  // -----   Finish   -------------------------------------------------------
  timer.Stop();
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  cout << endl << endl;
  cout << "*** DCH FINISHED ***" <<endl;
  cout << "Macro finished succesfully." << endl;
  cout << "Output file is "    << outFile << endl;
  cout << "Parameter file is " << parFile << endl;
  cout << "Real time " << rtime << " s, CPU time " << ctime << " s\a\a" << endl;
  cout << endl;

  exit(0);

}
