// -------------------------------------------------------------------------
// -----                   PndMcHitCount header file              -----
// -------------------------------------------------------------------------

/** PndMcHitCount.h
 * @author A. Herten <a.herten@fz-juelich.de> (based on work by S. Esch)
 * @date December 2014
 * @brief Saves the number of hits in the tracking detectors into RhoTuples
 *	
 *	 For MVD, STT, GEM and FTS, the number of hits by the current event is saved into respective RhoTuples. The number of hits is the number of FairLinks for a given MCTrack heading to "{MVD,STT,GEM,FTS}Point". 
 * 
 */

#ifndef PNDMCHITCOUNT_H_
#define PNDMCHITCOUNT_H_

#include <vector>
#include <map>

#include "TLorentzVector.h"

#include "FairTask.h"
// #include "PndMCMatch.h"

#include "PndGeoHandling.h"

class TClonesArray;
class RhoTuple;
class PndMCMatch;

class PndMcHitCount : public FairTask
{
public:

	/** Default constructor **/
	PndMcHitCount();

	/** Destructor **/
	virtual ~PndMcHitCount();

	/** Virtual method Init **/
	virtual InitStatus Init();


	/** Virtual method Exec **/
	virtual void Exec(Option_t *opt);

	virtual void Finish();

private:

	int eventcounter;

	PndGeoHandling* fGeoH;

	PndMCMatch *fMCMatch;
	TClonesArray *fMCTrack;
	TClonesArray * fMcIdealTrack;

	RhoTuple *fRhoNTuple;

	Int_t fPdgId, fHitsInMvd, fHitsInStt, fHitsInGem, fHitsInFts;
	TLorentzVector fP;
	TVector3 fVertex;
	Float_t fPx, fPy, fPz, fPt, fE;
	Float_t fTheta, fPhi;
	Int_t fMvdHitInLayer1,fMvdHitInLayer2,fMvdHitInLayer3,fMvdHitInLayer4;

	std::map<TString, Int_t> fLayerMap;

	void Register();

	void Reset();

	void ProduceHits();

	ClassDef(PndMcHitCount, 1);

};

#endif
