// -------------------------------------------------------------------------
// -----                   PndMcHitCount source file              -----
// -------------------------------------------------------------------------
#include <iostream>
#include <map>

#include "TROOT.h"
#include "TClonesArray.h"
#include "TLorentzVector.h"

#include "FairRootManager.h"
#include "FairRun.h"
#include "FairRuntimeDb.h"
#include "FairHit.h"
#include "FairMultiLinkedData.h"
#include "FairEventHeader.h"
#include "RhoHistogram/RhoTuple.h"

#include "PndMCEntry.h"
#include "PndMCTrack.h"
#include "PndMCResult.h"
#include "PndMCMatch.h"
#include "PndSdsMCPoint.h"
#include "PndSttPoint.h"
#include "PndTrackCand.h"

#include "PndMcHitCount.h"

// -----   Default constructor   -------------------------------------------
PndMcHitCount::PndMcHitCount()
	: FairTask("PndMcHitCount for Tracking Detectors") {
}
// -------------------------------------------------------------------------

// -----   Destructor   ----------------------------------------------------
PndMcHitCount::~PndMcHitCount() {
}

// -----   Public method Init   --------------------------------------------
InitStatus PndMcHitCount::Init() {
	eventcounter = 0;

	fGeoH = PndGeoHandling::Instance();

	FairRootManager *ioman = FairRootManager::Instance();
	if (!ioman) {
		std::cout << "-E- PndMcHitCount::Init: "
				  << "RootManager not instantiated!" << std::endl;
		return kFATAL;
	}

	// fMCMatch = (PndMCMatch *)ioman->GetObject("MCMatch");
	fMcIdealTrack = (TClonesArray*)ioman->GetObject("IdealTrackCand");

	// if ( ! fMCMatch ) {
	// 	std::cout << "-W-  PndMcHitCount::Init: No MCMatch array! Needed for MC Truth" << std::endl;
	// 	return kERROR;
	// }

	fMCTrack = (TClonesArray *)ioman->GetObject("MCTrack");
    ioman->GetObject("MVDPoint");

	fRhoNTuple = new RhoTuple("hitCount", "Hit counts Rho");

	std::cout << "-I- PndMcHitCount::Init: Initialization successful" << std::endl;

	fLayerMap["PixeloBlo1"] = 0;
	fLayerMap["PixeloBlo2"] = 0;
	fLayerMap["StripoBl3o(Silicon)"] = 0;
	fLayerMap["StripoBl4o(Silicon)"] = 0;

	fLayerMap["PixeloSdkoco(Silicon)_1"] = 0;
	fLayerMap["PixeloSdkoco(Silicon)_2"] = 0;
	fLayerMap["PixeloLdkoco(Silicon)_1"] = 0;
	fLayerMap["PixeloLdkoco(Silicon)_2"] = 0;
	fLayerMap["PixeloLdkoco(Silicon)_3"] = 0;
	fLayerMap["PixeloLdkoco(Silicon)_4"] = 0;
	fLayerMap["Fwdo(Silicon)_1"] = 0;
	fLayerMap["Fwdo(Silicon)_2"] = 0;

	return kSUCCESS;
}

// -----   Public method Exec   --------------------------------------------
void PndMcHitCount::Exec(Option_t *opt) {
	if (fVerbose > 0) {
		std::cout << "============= Begin PndMcHitCount+::Exec for Event " << eventcounter << std::endl;
	}

	FairRootManager *ioman = FairRootManager::Instance();

	fPdgId = 0;
	fHitsInMvd = 0;
	fHitsInStt = 0;
	fHitsInGem = 0;
	fHitsInFts = 0;
	fPx = 0;
	fPy = 0;
	fPz = 0;
	fPt = 0;
	fE = 0;
	fTheta = 0;
	fPhi = 0;

	std::cout << "fMCTrack->GetEntries(): " << fMCTrack->GetEntries() << "fMcIdealTrack->GetEntries(): " <<  fMcIdealTrack->GetEntries() << std::endl;

	for (int k = 0; k < fMCTrack->GetEntries() && k < fMcIdealTrack->GetEntries(); k++) {
		std::cout << "k: " << k << std::endl;
		PndMCTrack *myMcTrack = (PndMCTrack *) fMCTrack->At(k);
		PndTrackCand * currentEntry = (PndTrackCand *)fMcIdealTrack->At(k);
		if (myMcTrack->GetMotherID() == -1) {  // primary particle
			std::cout << "currentEntry: " << *currentEntry << std::endl;
			FairMultiLinkedData currentMvdLinks = currentEntry->GetLinksWithType(ioman->GetBranchId("MVDPoint"));
			FairMultiLinkedData currentSttLinks = currentEntry->GetLinksWithType(ioman->GetBranchId("STTPoint"));
			FairMultiLinkedData currentGemLinks = currentEntry->GetLinksWithType(ioman->GetBranchId("GEMPoint"));
			FairMultiLinkedData currentFtsLinks = currentEntry->GetLinksWithType(ioman->GetBranchId("FTSPoint"));

			fPdgId = (Int_t) myMcTrack->GetPdgCode();
			fP = (TLorentzVector) myMcTrack->Get4Momentum();
			fPx = fP.Px();
			fPy = fP.Py();
			fPz = fP.Pz();
			fPt = fP.Pt();
			fE = fP.E();
			fTheta = fP.Theta();
			fPhi = fP.Phi();
			fHitsInMvd = (Int_t) currentMvdLinks.GetNLinks();
			fHitsInStt = (Int_t) currentSttLinks.GetNLinks();
			fHitsInGem = (Int_t) currentGemLinks.GetNLinks();
			fHitsInFts = (Int_t) currentFtsLinks.GetNLinks();

			for (Int_t i = 0;  i < currentMvdLinks.GetNLinks(); i++){
				PndSdsMCPoint* myHit = (PndSdsMCPoint*)FairRootManager::Instance()->GetCloneOfLinkData(currentMvdLinks.GetLink(i));
                std::cout << *myHit << std::endl;
				TString geoPath = fGeoH->GetPath(myHit->GetSensorID());

				std::map<TString, Int_t>::iterator layerIter;
				for (layerIter = fLayerMap.begin(); layerIter != fLayerMap.end(); layerIter++){
					if(geoPath.Contains(layerIter->first)){
						layerIter->second++;
					}
				}
			}

			fRhoNTuple->Column("HitInLayer1", (Int_t) fLayerMap["PixeloBlo1"]);
			fRhoNTuple->Column("HitInLayer2", (Int_t) fLayerMap["PixeloBlo2"]);
			fRhoNTuple->Column("HitInLayer3", (Int_t) fLayerMap["StripoBl3o(Silicon)"]);
			fRhoNTuple->Column("HitInLayer4", (Int_t) fLayerMap["StripoBl4o(Silicon)"]);

			fRhoNTuple->Column("HitInDisk1", (Int_t) fLayerMap["PixeloSdkoco(Silicon)_1"]);
			fRhoNTuple->Column("HitInDisk2", (Int_t) fLayerMap["PixeloSdkoco(Silicon)_2"]);
			fRhoNTuple->Column("HitInDisk3", (Int_t) fLayerMap["PixeloLdkoco(Silicon)_1"]);
			fRhoNTuple->Column("HitInDisk4", (Int_t) fLayerMap["PixeloLdkoco(Silicon)_2"]);
			fRhoNTuple->Column("HitInDisk5", (Int_t) fLayerMap["PixeloLdkoco(Silicon)_3"]);
			fRhoNTuple->Column("HitInDisk6", (Int_t) fLayerMap["PixeloLdkoco(Silicon)_4"]);
			fRhoNTuple->Column("HitInDisk7", (Int_t) fLayerMap["Fwdo(Silicon)_1"]);
			fRhoNTuple->Column("HitInDisk8", (Int_t) fLayerMap["Fwdo(Silicon)_2"]);

			fLayerMap["PixeloBlo1"] = 0;
			fLayerMap["PixeloBlo2"] = 0;
			fLayerMap["StripoBl3o(Silicon)"] = 0;
			fLayerMap["StripoBl4o(Silicon)"] = 0;
			fLayerMap["PixeloSdkoco(Silicon)_1"] = 0;
			fLayerMap["PixeloSdkoco(Silicon)_2"] = 0;
			fLayerMap["PixeloLdkoco(Silicon)_1"] = 0;
			fLayerMap["PixeloLdkoco(Silicon)_2"] = 0;
			fLayerMap["PixeloLdkoco(Silicon)_3"] = 0;
			fLayerMap["PixeloLdkoco(Silicon)_4"] = 0;
			fLayerMap["Fwdo(Silicon)_1"] = 0;
			fLayerMap["Fwdo(Silicon)_2"] = 0;

			fRhoNTuple->Column("PdgId", (Int_t) fPdgId);
			fRhoNTuple->Column("Px", (Float_t) fPx);
			fRhoNTuple->Column("Py", (Float_t) fPy);
			fRhoNTuple->Column("Pz", (Float_t) fPz);
			fRhoNTuple->Column("Pt", (Float_t) fPt);
			fRhoNTuple->Column("E", (Float_t) fE);
			fRhoNTuple->Column("Theta", (Float_t) fTheta);
			fRhoNTuple->Column("Phi", (Float_t) fPhi);
			fRhoNTuple->Column("HitsInMvd", (Int_t) fHitsInMvd);
			fRhoNTuple->Column("HitsInStt", (Int_t) fHitsInStt);
			fRhoNTuple->Column("HitsInGem", (Int_t) fHitsInGem);
			fRhoNTuple->Column("HitsInFts", (Int_t) fHitsInFts);
			fRhoNTuple->Column("EventNumber", (Int_t) eventcounter);
			fRhoNTuple->Column("FairLinkNumber", (Int_t) k);

			fRhoNTuple->DumpData();
		}
	}

	if (fVerbose > 0) {
		std::cout << "============= End PndMcHitCount+::Exec for Event " << eventcounter << std::endl;
	}
	eventcounter++;
}

void PndMcHitCount::Finish()
{
	gDirectory->cd();
	fRhoNTuple->GetInternalTree()->Write();
	gDirectory->cd("/");

}


ClassImp(PndMcHitCount);
