void hitcount(Int_t nEvents = 0) {
    // ========================================================================

    Int_t iVerbose = 0;

    TString parFile = "simparams.root";
    TString simFile = "sim_complete.root";
    TString digiFile = "digi_complete.root";
    // TString anaParFile = "";
    TString outputFile = "mc_hitcount.root";

    // -----   Timer   --------------------------------------------------------
    TStopwatch timer;
    timer.Start();
    // ------------------------------------------------------------------------

    // -----   Reconstruction run   -------------------------------------------
    FairRunAna *fRun = new FairRunAna();

    fRun->SetInputFile(simFile);
    fRun->AddFriend(digiFile);
    // fRun->AddFriend(recoFile);

    fRun->SetOutputFile(outputFile);
    // ------------------------------------------------------------------------

    TString anaParFile = gSystem->Getenv("VMCWORKDIR");
    anaParFile +=  "/macro/params/all.par";
    FairParAsciiFileIo *parIo1 = new FairParAsciiFileIo();
    parIo1->open(anaParFile.Data(), "in");

    // -----  Parameter database   --------------------------------------------
    FairRuntimeDb *rtdb = fRun->GetRuntimeDb();

    FairParRootFileIo *parInput1 = new FairParRootFileIo(kTRUE);
    parInput1->open(parFile.Data(), "UPDATE");

    rtdb->setFirstInput(parInput1);
    rtdb->setSecondInput(parIo1);
    Bool_t kParameterMerged = kTRUE;
    rtdb->setOutput(parInput1);
    rtdb->print();


    // -----------------------------------------------------------------------



    // =========================================================================
    // ======                       Hit Producers                         ======
    // =========================================================================



    // PndMCMatchCreatorTask *mcMatch = new PndMCMatchCreatorTask();
    // mcMatch->SetVerbose(1);
    // fRun->AddTask(mcMatch);

    fRun->SetUseFairLinks(kTRUE);
    PndMCIdealTrackFinderNewLinks *idealtrackfinder = new PndMCIdealTrackFinderNewLinks();
    fRun->AddTask(idealtrackfinder);

    PndMcHitCount * hitCountTask = new PndMcHitCount();
    fRun->AddTask(hitCountTask);

    fRun->Init();
    fRun->Run(0, nEvents);

    // ------------------------------------------------------------------------

    // rtdb->saveOutput();
    // -----   Finish   -------------------------------------------------------
    timer.Stop();
    Double_t rtime = timer.RealTime();
    Double_t ctime = timer.CpuTime();
    cout << endl << endl;
    cout << "Macro finished succesfully." << endl;
    cout << "Output file is "    << outputFile << endl;
    cout << "Parameter file is " << parFile << endl;
    cout << "Real time " << rtime << " s, CPU time " << ctime << " s" << endl;
    cout << endl;
    // ------------------------------------------------------------------------


}
