class RhoCandList;
class RhoCandidate;
class PndAnaPidSelector;
class PndAnaPidCombiner;
class PndAnalysis;


void run_ana_DstarDstar(int nevts=0)
{
  // *** some variables
  int i=0,j=0, k=0, l=0;
  gStyle->SetOptFit(0001);
  
  // *** the output file for FairRunAna
  TString OutFile="output.root";  
  
  // *** the files coming from the simulation
  TString inPidFile  = "pid_complete_GT.root";    // this file contains the PndPidCandidates and McTruth
  TString inParFile  = "simparams_GT.root";
  
  // *** PID table with selection thresholds; can be modified by the user
  TString pidParFile = TString(gSystem->Getenv("VMCWORKDIR"))+"/macro/params/all.par";	
  
  // *** initialization
  FairLogger::GetLogger()->SetLogToFile(kFALSE);
  FairRunAna* fRun = new FairRunAna();
  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
  fRun->SetInputFile(inPidFile);
  
  // *** setup parameter database 	
  FairParRootFileIo* parIO = new FairParRootFileIo();
  parIO->open(inParFile);
  FairParAsciiFileIo* parIOPid = new FairParAsciiFileIo();
  parIOPid->open(pidParFile.Data(),"in");
  
  rtdb->setFirstInput(parIO);
  rtdb->setSecondInput(parIOPid);
  rtdb->setOutput(parIO);  
  
  fRun->SetOutputFile(OutFile);
  fRun->Init(); 
  
  // *** create an output file for all histograms
  TFile *out = TFile::Open("output_histograms.root","RECREATE");
  
  // TCanvas *c1 = new TCanvas("c1","c",800,600);
  // c1->Divide(2,1);
  // c1->GetFrame()->SetFillColor(21);
  // c1->GetFrame()->SetBorderSize(21);
  
  //TCanvas *c2 = new TCanvas("c2","c",800,600);
  // c2->Divide(2,1);
  // c2->GetFrame()->SetFillColor(21);
  // c2->GetFrame()->SetBorderSize(21);
  
  // *** create some histograms
  

  TH1F *DzeroMass = new TH1F("InvMass_D^{0}","",100,0.5,5.0);
  DzeroMass->GetXaxis()->SetTitle("M_{inv}[K^{-}#pi^{+}][GeV/c^{2}]");
  DzeroMass->GetYaxis()->SetTitle("Events");
  DzeroMass->GetXaxis()->CenterTitle();
  DzeroMass->GetYaxis()->CenterTitle();
  DzeroMass->GetXaxis()->SetTitleFont(62);
  DzeroMass->GetYaxis()->SetTitleFont(62);
  DzeroMass->GetXaxis()->SetLabelOffset(0.005);
  DzeroMass->GetYaxis()->SetLabelOffset(0.005);
  DzeroMass->GetXaxis()->SetLabelFont(62);
  DzeroMass->GetYaxis()->SetLabelFont(62);

  TH1F *Anti_DzeroMass = new TH1F("InvMass_#bar{D^{0}}","",100,0.5.,5.0);
  Anti_DzeroMass->GetXaxis()->SetTitle("M_{inv}[K^{+}#pi^{-}][GeV/c^{2}]");
  Anti_DzeroMass->GetYaxis()->SetTitle("Events");
  Anti_DzeroMass->GetXaxis()->CenterTitle();
  Anti_DzeroMass->GetYaxis()->CenterTitle();
  Anti_DzeroMass->GetXaxis()->SetTitleFont(62);
  Anti_DzeroMass->GetYaxis()->SetTitleFont(62);
  Anti_DzeroMass->GetXaxis()->SetLabelOffset(0.005);
  Anti_DzeroMass->GetYaxis()->SetLabelOffset(0.005);
  Anti_DzeroMass->GetXaxis()->SetLabelFont(62);
  Anti_DzeroMass->GetYaxis()->SetLabelFont(62);


  TH1F *DstarPMass = new TH1F("InvMass_D*+","",100,0.5,5.0);
  DstarPMass->GetXaxis()->SetTitle("m_{inv}[D^{0}#pi^{+}][GeV/c^{2}]");
  DstarPMass->GetYaxis()->SetTitle("Events");
  DstarPMass->GetXaxis()->CenterTitle();
  DstarPMass->GetYaxis()->CenterTitle();
  // DstarPMass->GetXaxis()->SetTitleOffset("1.0");
  // DstarPMass->GetYaxis()->SetTitleOffset("1.0");
  DstarPMass->GetXaxis()->SetTitleFont(62);
  DstarPMass->GetYaxis()->SetTitleFont(62);
  DstarPMass->GetXaxis()->SetLabelOffset(0.005);
  DstarPMass->GetYaxis()->SetLabelOffset(0.005);
  DstarPMass->GetXaxis()->SetLabelFont(62);
  DstarPMass->GetYaxis()->SetLabelFont(62);

  TH1F *DstarMMass = new TH1F("InvMass_D*-","",100,0.5,5.0);
  DstarMMass->GetXaxis()->SetTitle("m_{inv}[#bar{D^{0}}#pi^{-}][GeV/c^{2}]");
  DstarMMass->GetYaxis()->SetTitle("Events");
  DstarMMass->GetXaxis()->CenterTitle();
  DstarMMass->GetYaxis()->CenterTitle();
  // DstarPMass->GetXaxis()->SetTitleOffset("1.0");
  // DstarPMass->GetYaxis()->SetTitleOffset("1.0");
  DstarMMass->GetXaxis()->SetTitleFont(62);
  DstarMMass->GetYaxis()->SetTitleFont(62);
  DstarMMass->GetXaxis()->SetLabelOffset(0.005);
  DstarMMass->GetYaxis()->SetLabelOffset(0.005);
  DstarMMass->GetXaxis()->SetLabelFont(62);
  DstarMMass->GetYaxis()->SetLabelFont(62);
  
  //
  // Now the analysis stuff comes...
  //
  
  
  // *** the data reader object
  PndAnalysis* theAnalysis = new PndAnalysis();
  if (nevts==0) nevts= theAnalysis->GetEntries();
  
  // *** RhoCandLists for the analysis
  RhoCandList DstarP, DstarM, Dzero,antiDzero, piplus,piminus,kplus,kminus;
  
  
  // the event loop
  // ***
  while (theAnalysis->GetEvent() && i++<nevts)
    {
      if ((i%100)==0) cout<<"evt " << i << endl;
      
      // *** Select with no PID info ('All'); type and mass are set 		
      theAnalysis->FillList(piplus, "PionAllPlus");
      theAnalysis->FillList(piminus,"PionAllMinus");
      theAnalysis->FillList(kplus,  "KaonAllPlus");
      theAnalysis->FillList(kminus, "KaonAllMinus");
      
      Dzero.Cleanup();
      antiDzero.Cleanup();
      DstarP.Cleanup();
      DstarM.Cleanup();
      
      Dzero.Combine(kminus,piplus);
      antiDzero.Combine(kplus,piminus);
      DstarP.Combine(Dzero,piplus);
      DstarM.Combine(antiDzero,piminus);
      
      
      Dzero.SetType(421);
      antiDzero.SetType(-421);
      DstarP.SetType(413);
      DstarM.SetType(-413);
      
     
      for (Int_t m=0; m<Dzero.GetLength();++m) 
	{
	  DzeroMass->Fill( Dzero[m]->M() );
	}
     	
      
      for (Int_t j=0;j<antiDzero.GetLength();++j) 
	{
	  Anti_DzeroMass->Fill( antiDzero[j]->M() );
	}
      
      for (Int_t k=0; k<DstarP.GetLength();++k) 
	{
	  DstarPMass->Fill( DstarP[k]->M() );
	}
      
 						
      for (Int_t l=0; l<DstarM.GetLength();++l) 
	{
	  DstarMMass->Fill( DstarM[l]->M() );
	}   
      
    }
  
  // *** write out all the histos
 
  TF1 *f1 = new TF1("f1","gaus",1.797,1.935);
       
  DzeroMass->Fit("f1","R");

	
  TF1 *f2 = new TF1("f2","gaus",1.797,1.935);
 
  Anti_DzeroMass->Fit("f2","R");

  
  TF1 *f3 = new TF1("f3","gaus",1.962,2.06);
  
  DstarPMass->Fit("f3","R");
  
  TF1 *f4 = new TF1("f4","gaus",1.962,2.06);
  

  DstarMMass->Fit("f4","R");
  
  /* out->cd();
  DzeroMass->Write();
  Anti_DzeroMass->Write();
  DstarPMass->Write();
  DstarMMass->Write();
  out->Save();*/

  TCanvas *c1 = new TCanvas("c1","GlobalTracking_Macro",800,600);
  c1->GetFrame()->SetFillColor(21);
  c1->GetFrame()->SetBorderSize(21);
  c1->Divide(2,2);
  c1->cd(1);
  DzeroMass->Draw();
  c1->cd(2);
  Anti_DzeroMass->Draw();
  c1->cd(3);
  DstarPMass->Draw();
  c1->cd(4);
  DstarMMass->Draw();
}
