#ifndef AGATA_ScintillatorArray_HPP_
#define AGATA_ScintillatorArray_HPP_

#include <prespec/process/Processor.hpp>

#include <map>
#include <vector>


//! @brief This processor handles (large volume) Scintillators
class ScintillatorArray : public prespec::process::Processor
{
	public:
		ScintillatorArray(const std::string &config_dir,
				    const std::string &name,
				    bool no_files);
		~ScintillatorArray();
		
		virtual void process(prespec::viscon::Interface &viscon_interface, int trigger);
		
	    // the inputs to this processor

		enum Input
		{
			beta_measured,	//beta calculated in LYCCA //tayfun
			xin,
			yin,
			xtarget,
			ytarget,
			xout,
			yout,
		};

		
		enum InputArray
		{
			amplitude1,   // first energy signal
			amplitude2,   // second energy signal
			tdc_channel,      // time 
		};

		enum Output
		{
			e1_multiplicity,
			e2_multiplicity,
			t_multiplicity,
		};

		// the outputs of this processor
		enum OutputArray
		{
			energy1,
			energy2,
			time,
			energy1_DC,
			energy2_DC,
		};
		
		enum Parameter
		{
			n_detectors,
			const_beta,   // beta for Doppler correction
//			position,    // theta[deg], r, phi[deg] of the detector
			Encartx,
			Encarty,
			Encartz,
			ztarget,
			ztarget_offset,
			ytarget_offset,
			xtarget_offset,	
			zin,
			zout,
		};
		
		enum Coefficents
		{
			cal_energy1,
			cal_energy2,
			cal_time,
		};
		

	private:
		void correctDoppler(double E, double beta, double ct,
							double &Erest, double &ct_rest);
		double costheta(double x_p, double y_p,double z_p, 
						double x_g, double y_g,double z_g);
};


#endif
