//#include "TString.h"
//#include "TROOT.h"
//#include "TSystem.h"
//#include "TH1.h"
//#include "TH2.h"
//#include "TCanvas.h"
//#include "TLine.h"
//#include "TLorentzVector.h"
//#include "TStyle.h"
//#include "TRandom.h"
//#include "TStopwatch.h"
//
//#include <stdio.h>
//#include <iostream>
//using namespace std;
//
//// Panda Libs
//#include "FairLogger.h"
//#include "FairRunAna.h"
//#include "FairRuntimeDb.h"
//#include "FairParRootFileIo.h"
//
//#include "RhoBase/RhoCandidate.h"
//#include "RhoBase/RhoCandList.h"
////#include "RhoBase/RhoFitParams.h"
////#include "RhoBase/VAbsMicroCandidate.h"
////#include "RhoSelector/TPidSelector.h"
//
////#include "AnalysisTools/PndMcTruthMatch.h"
//#include "AnalysisTools/PndAnalysis.h"
//#include "AnalysisTools/PndAnaPidCombiner.h"
//#include "AnalysisTools/PndAnaPidSelector.h"
//#include "AnalysisTools/Fitter/PndVtxPRG.h"
//#include "AnalysisTools/Fitter/PndVtxPoca.h"

void anatut_psi2s()
{
	TString OutFile="output.root";

	// *** some variables
	Int_t nevts=0;
	Int_t ievts=0, pionskicked=0, mcpions=0, detectpions=0, primarymcpions=0, primarydetectedpions=0, nallpions=0, k0kick=0;
	Int_t nallparticles=0, nallkaons=0;
	const double val=15.0; // will be pbar momentum

	//val is the momentum of the pbar beam
	const double mp=0.93827;
	double P = val;
	double E = mp+TMath::Sqrt(P*P+mp*mp);
	TLorentzVector ini(0, 0, P, E);  // *** the lorentz vector of the initial pbar

	// *** the files coming from the simulation
	TString inPidFile  = "pid_complete.root";    // this file contains the PndPidCandidates
	TString inRecoFile  = "reco_complete.root";
	TString inSimFile = "sim_complete.root";  // this file contains the MC truth
	TString inParFile = "simparams.root";

	gROOT->SetStyle("Plain");

	gStyle->SetOptFit(1011);
	// load Root classes
	gROOT->Macro("$VMCWORKDIR/gconfig/rootlogon.C");

	// make StatBox in histograms show more useful information
	gStyle->SetOptStat(1111110); // with integral
	//gStyle->SetOptStat(111110); // without integral

	FairLogger::GetLogger()->SetLogToFile(kFALSE);

	// *** initialization
	FairRunAna* fRun = new FairRunAna();
	FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
	// *** add signal files
	fRun->SetInputFile(inSimFile);
	fRun->AddFriend(inPidFile);
	fRun->AddFriend(inRecoFile);

	FairParRootFileIo* parIO = new FairParRootFileIo();
	parIO->open(inParFile);
	rtdb->setFirstInput(parIO);
	rtdb->setOutput(parIO);

	fRun->SetOutputFile(OutFile);
	fRun->Init();

	// *** Timer
	TStopwatch timer;

	// *** create an output file for all histograms
	TFile *out = TFile::Open("output_psi2sana.root","RECREATE");

	// *** createing some histograms
	TH1F *nkaons = new TH1F("nkaons", "number of kaons", 6, 0, 5);
	TH1F *nkaonstight = new TH1F("nkaonstight", "number of kaons - pidalgos:tight", 6, 0, 5);
	TH1F *npart = new TH1F("npart", "number of particles", 16, 0, 15);
	TH1F *npions = new TH1F("npions","number of pions", 16, 0, 15);
	TH1F *k0im = new TH1F("k0im","invariant mass of combined K^0", 400, 0, 2);
//	TH1F *nkaonsandk0 = new TH1F("nkaonsandk0", "number of kaons(+- and 0)", 6, 0, 5);
	TH1F *kaonposz = new TH1F("kaonposz","kaonposz",100,-1,1);


	// *** creating tuple
	TNtuple *truetuple = new TNtuple("truetuple","truetuple","nallkaons:nallparticles:nallpions:rm:pocadistance:pocaVtxX:pocaVtxY:pocaVtxZ:radial:massdifftrue:PRGvtxX:PRGvtxY:PRGvtxZ:PRGradial:pz1:pz2:chi2");
	TNtuple *combtuple = new TNtuple("combtuple","combtuple","nallkaons:nallparticles:nallpions:rm:pocadistance:pocaVtxX:pocaVtxY:pocaVtxZ:radial:PRGvtxX:PRGvtxY:PRGvtxZ:PRGradial:pz1:pz2:chi2");
	TNtuple *pidtuple = new TNtuple("pidtuple","pidtuple","nallkaons:nallparticles:nallpions:rm:pocadistance:pocaVtxX:pocaVtxY:pocaVtxZ:radial:PRGvtxX:PRGvtxY:PRGvtxZ:PRGradial:pz1:pz2:chi2");
	TNtuple *falsetuple = new TNtuple("falsetuple","falsetuple","nallkaons:nallparticles:nallpions:rm:pocadistance:pocaVtxX:pocaVtxY:pocaVtxZ:radial:PRGvtxX:PRGvtxY:PRGvtxZ:PRGradial:pz1:pz2:chi2");
	TNtuple *truemctuple = new TNtuple("truemctuple","truemctuple","nallkaons:nallparticles:nallpions:rm:pocadistance:pocaVtxX:pocaVtxY:pocaVtxZ:radial:massdifftrue:PRGvtxX:PRGvtxY:PRGvtxZ:PRGradial:pz1:pz2:chi2");
	TNtuple *falsemctuple = new TNtuple("falsemctuple","falsemctuple","nallkaons:nallparticles:nallpions:rm:pocadistance:pocaVtxX:pocaVtxY:pocaVtxZ:radial:massdifftrue:PRGvtxX:PRGvtxY:PRGvtxZ:PRGradial:pz1:pz2:chi2");
	TNtuple *momentumtuple = new TNtuple("momentumtuple","momentumtuple","pz:part");
	TNtuple *kaonmomentumtuple = new TNtuple("kaonmomentumtuple","kaonmomentumtuple","kpz:charg");

	// *** the data reader object
	PndAnalysis* theAnalysis = new PndAnalysis("SttMvdGemGenTrack","FtsIdealGenTrack");
	if (nevts==0) nevts= theAnalysis->GetEntries();

	// *** PID algorithm
	TString pidalgos("PidAlgoStt;PidAlgoEmcBayes;PidAlgoDrc;PidAlgoDisc");
	//	TString pidalgos("PidAlgoMvd;PidAlgoStt;PidAlgoEmcBayes;PidAlgoDrc;PidAlgoDisc");

	// *** TCandLists for the analysis
	RhoCandList mctrk, mcpiplus, mcpiminus, piplus, piminus, comball, eplus, eminus, muplus, muminus, kplus, kminus, allparticles, kaons;
	RhoCandList pidpiplus, pidpiminus, combpid;
	RhoCandList truepiplus, truepiminus, combtrue;
	RhoCandList truemcpiplus, truemcpiminus, combmctrue, combmcfalse1, combmcfalse2, combmcfalse3;
	RhoCandList falsemcpiplus, falsemcpiminus, combmcfalse;
	RhoCandList falsepiplus, falsepiminus, combfalse;
	RhoCandList combk0;
	// *** the MC truth matcher variable
//	PndMcTruthMatch mcm;

	// ***
	// the event loop
	// ***
	timer.Start();
	while (theAnalysis->GetEvent() && ievts++<nevts)
	{
		if ((ievts%100)==0)
			cout << "Evt: " << ievts << endl;

		// *** the MC Truth objects
		theAnalysis->FillList(mctrk,"McTruth");

		// *** Select with PID info; type and mass are set
		theAnalysis->FillList(eplus, "ElectronVeryTightPlus",pidalgos);
		theAnalysis->FillList(eminus, "ElectronVeryTightMinus",pidalgos);
		theAnalysis->FillList(muplus, "MuonVeryTightPlus",pidalgos);
		theAnalysis->FillList(muminus, "MuonVeryTightMinus",pidalgos);
		theAnalysis->FillList(kminus, "KaonVeryTightMinus");
		theAnalysis->FillList(kplus, "KaonVeryTightPlus");
		theAnalysis->FillList(piplus, "PionLoosePlus",pidalgos);
		theAnalysis->FillList(piminus, "PionLooseMinus",pidalgos);
		theAnalysis->FillList(mcpiplus, "PionLoosePlus");
		theAnalysis->FillList(mcpiminus, "PionLooseMinus");
		theAnalysis->FillList(kaons, "KaonTight",pidalgos);
		nkaonstight->Fill(kaons.GetLength());
		nkaons->Fill(kaons.GetLength());
		theAnalysis->FillList(kaons, "KaonTight");
		nallkaons=kaons.GetLength();
		theAnalysis->FillList(allparticles, "Charged");
		npart->Fill(allparticles.GetLength());
		nallparticles=allparticles.GetLength();

		detectpions+=piplus.GetLength(); detectpions+=piminus.GetLength();
		mcpions+=mcpiplus.GetLength(); mcpions+=mcpiminus.GetLength();
		nallpions=mcpiplus.GetLength()+mcpiminus.GetLength();
		npions->Fill(mcpiplus.GetLength()+mcpiminus.GetLength());

		// Remove electrons and muons in pi lists
		for(Int_t l=0;l<eplus.GetLength();++l) pionskicked=piplus.Remove(eplus[l]);
		for(Int_t l=0;l<muplus.GetLength();++l) pionskicked=piplus.Remove(muplus[l]);
		for(Int_t l=0;l<kplus.GetLength();++l) pionskicked=piplus.Remove(kplus[l]);
		for(Int_t l=0;l<eminus.GetLength();++l) pionskicked=piminus.Remove(eminus[l]);
		for(Int_t l=0;l<muminus.GetLength();++l) pionskicked=piminus.Remove(muminus[l]);
		for(Int_t l=0;l<kminus.GetLength();++l) pionskicked=piminus.Remove(kminus[l]);

		pidpiplus.Cleanup();
		pidpiminus.Cleanup();
		truepiplus.Cleanup();
		truepiminus.Cleanup();
		truemcpiplus.Cleanup();
		truemcpiminus.Cleanup();
		falsepiplus.Cleanup();
		falsepiminus.Cleanup();
		falsemcpiplus.Cleanup();
		falsemcpiminus.Cleanup();

		// secondary vertex cut of k+- and pi-+ at 2mm
		Float_t dcut=0.2;
		Bool_t dflag=kFALSE;
/*		combk0.Combine(kplus,allparticles);
		mcm.SetType(combk0,421);
		for(Int_t i=0;i<combk0.GetLength();i++) {
			mcm.MctMatch(combk0[i],mctrk);
			// PndVtxPRG Vertex Fitter
			PndVtxPRG prgfitter(combk0[i]);
			TVector3 vertD;
			TMatrixD vtxcov(3,3);
			prgfitter.FitVertexFast(vertD,vtxcov);
			if(mcm.MctMatch(combk0[i],mctrk)) cout << "   " << vertD.Z() << endl;
//			if(vertD.Z()<dcut){
//				dflag=kTRUE;
//				break;
//			}
		}
		combk0.Combine(kminus,allparticles);
		mcm.SetType(combk0,421);
		for(Int_t i=0;i<combk0.GetLength();i++) {
			// PndVtxPRG Vertex Fitter
			PndVtxPRG prgfitter(combk0[i]);
			TVector3 vertD;
			TMatrixD vtxcov(3,3);
			prgfitter.FitVertexFast(vertD,vtxcov);
			if(mcm.MctMatch(combk0[i],mctrk))cout << "   " << vertD.Z() << endl;
//			if(vertD.Z()<dcut){
//				dflag=kTRUE;
//				break;
//			}
		}*/
		k0kick+=nallkaons;
		for(Int_t i=0;i<kaons.GetLength();i++) {
			// PndVtxPRG Vertex Fitter
//			PndVtxPRG prgfitter(kaons[i]);
//			TVector3 vertD;
//			TMatrixD vtxcov(3,3);
//			prgfitter.FitVertexFast(vertD,vtxcov);
//			if(mcm.MctMatch(kaons[i],mctrk)) {
//				Int_t test=mctrk[kaons[i].GetMcIdx()].GetMcMotherIdx();
//				if(test>0)
//				if(mctrk[test].PdgCode()==411 || mctrk[test].PdgCode()==-411 || mctrk[test].PdgCode()==413 || mctrk[test].PdgCode()==-413
//				|| mctrk[test].PdgCode()==421 || mctrk[test].PdgCode()==-421 || mctrk[test].PdgCode()==423 || mctrk[test].PdgCode()==-423)
//				{
//					cout << "   " << kaons[i].Pos().Z() << endl;
					kaonposz->Fill(kaons[i]->Pos().Z());
//				}

//			}
//			if(!mcm.MctMatch(kaons[i],mctrk)) cout << " " << kaons[i]->Pos().Z() << endl;
//			if(kaons[i]->GetMcTruth()) cout << " " << kaons[i]->Pos().Z() << endl;
		}
//		dflag=kTRUE;
//		if(dflag) continue;


		// truth match for pi +
		for (Int_t ipiplus=0;ipiplus<piplus.GetLength();++ipiplus){
			RhoCandidate *truth = piplus[ipiplus]->GetMcTruth();
			if (truth && truth !=(RhoCandidate*)0x8011){
				pidpiplus.Add(piplus[ipiplus]);
				// TRUE PRIMARY PION SELECTION
				RhoCandidate* motherId = piplus[ipiplus]->GetMcTruth()->TheMother();
				if(motherId && motherId!=(RhoCandidate*)0x10011) {
					if(motherId->PdgCode()==88888) {
						truepiplus.Add(piplus[ipiplus]);
					} else {
						falsepiplus.Add(piplus[ipiplus]);
					}
				}
			} else {
				falsepiplus.Add(piplus[ipiplus]);
			}
		}
		primarydetectedpions+=truepiplus.GetLength();

		// truth match for pi -
		for (Int_t ipiminus=0;ipiminus<piminus.GetLength();++ipiminus){
			RhoCandidate *truth = piminus[ipiminus]->GetMcTruth();
			if (truth && truth !=(RhoCandidate*)0x8011){
				if(piminus[ipiminus]->PdgCode()!=-211) cout << "miss identification!!!" << endl;
				pidpiminus.Add(piminus[ipiminus]);
				// TRUE PRIMARY PION SELECTION
				RhoCandidate* motherId = piminus[ipiminus]->GetMcTruth()->TheMother();
				if(motherId && motherId!=(RhoCandidate*)0x10011) {
					if(motherId->PdgCode()==88888) {
						truepiminus.Add(piminus[ipiminus]);
					} else {
						falsepiminus.Add(piminus[ipiminus]);
					}
				}
			} else {
				falsepiminus.Add(piminus[ipiminus]);
			}
		}
		primarydetectedpions+=truepiminus.GetLength();

		// COMBINATION
		comball.Combine(piplus,piminus);
		combpid.Combine(pidpiplus,pidpiminus);
		combtrue.Combine(truepiplus,truepiminus);
		combfalse.Combine(falsepiplus,falsepiminus);

		// ANALYSE of PRIMARY combined PIONS
		Float_t massdifftrue=10000; // mass difference between best missing mass and true mass for h_c^'
		Int_t minmassdiffIdx=0;// stores index of best combtrue found
		for (int l=0;l<combtrue.GetLength();++l) {
			// recoil mass calculation
			TLorentzVector mm = ini-combtrue[l]->P4();
			Float_t rm=mm.M();
			if (TMath::Abs(rm-mctrk[1]->Mass())<massdifftrue){
				massdifftrue= TMath::Abs(rm-mctrk[1]->Mass());
				minmassdiffIdx=l;
			}
		} // analyse for just the one combined primary particle
		if(combtrue.GetLength()>0){
				// recoil mass calculation
				TLorentzVector mm = ini-combtrue[minmassdiffIdx]->P4();
				Float_t rm=mm.M();
				Float_t pz1=TMath::Abs(combtrue[minmassdiffIdx]->Daughter(0)->P());
				Float_t pz2=TMath::Abs(combtrue[minmassdiffIdx]->Daughter(1)->P());

				// PndVtxPRG Vertex Fitter
				PndVtxPRG prgfitter(combtrue[minmassdiffIdx]);
				prgfitter.Fit();
				TVector3 PRGvtx=combtrue[minmassdiffIdx]->GetFit()->Daughter(0)->GetPosition();
				Float_t chi2=prgfitter.GetChi2();
				Float_t PRGvtxX=PRGvtx.X();
				Float_t PRGvtxY=PRGvtx.Y();
				Float_t PRGvtxZ=PRGvtx.Z();
				Float_t PRGradial;
				PRGradial=PRGvtxX*PRGvtxX+PRGvtxY*PRGvtxY;

				// determine pseudo vertex *** POCA
				PndVtxPoca poca;
				TVector3 pocavtx;
				Float_t pocadistance = poca.GetPocaVtx(pocavtx,combtrue[minmassdiffIdx]);
				Float_t pocaVtxX=pocavtx.X();
				Float_t pocaVtxY=pocavtx.Y();
				Float_t pocaVtxZ=pocavtx.Z();
				Float_t radial;
				radial=pocaVtxX*pocaVtxX+pocaVtxY*pocaVtxY;

				Float_t combtuplearray[] = {nallkaons, nallparticles, nallpions, rm, pocadistance, pocaVtxX, pocaVtxY, pocaVtxZ, radial, massdifftrue, PRGvtxX, PRGvtxY, PRGvtxZ, PRGradial, pz1, pz2, chi2};
				truetuple->Fill(combtuplearray);
		}

		// ANALYSE of ALL combined "PIONS"
		for (int l=0;l<comball.GetLength();++l) {
			// recoil mass calculation
			TLorentzVector mm = ini-comball[l]->P4();
			Float_t rm=mm.M();
			Float_t pz1=TMath::Abs(comball[l]->Daughter(0)->P());
			Float_t pz2=TMath::Abs(comball[l]->Daughter(1)->P());

			// PndVtxPRG Vertex Fitter
			PndVtxPRG prgfitter(comball[l]);
			prgfitter.Fit();
			TVector3 PRGvtx=comball[l]->GetFit()->Daughter(0)->GetPosition();
			Float_t chi2=prgfitter.GetChi2();
			Float_t PRGvtxX=PRGvtx.X();
			Float_t PRGvtxY=PRGvtx.Y();
			Float_t PRGvtxZ=PRGvtx.Z();
			Float_t PRGradial;
			PRGradial=PRGvtxX*PRGvtxX+PRGvtxY*PRGvtxY;

			// determine pseudo vertex *** POCA
			PndVtxPoca poca;
			TVector3 pocavtx;
			Float_t pocadistance = poca.GetPocaVtx(pocavtx,comball[l]);
			Float_t pocaVtxX=pocavtx.X();
			Float_t pocaVtxY=pocavtx.Y();
			Float_t pocaVtxZ=pocavtx.Z();
			Float_t radial;
			radial=pocaVtxX*pocaVtxX+pocaVtxY*pocaVtxY;

			Float_t combtuplearray2[]={nallkaons, nallparticles, nallpions, rm,pocadistance, pocaVtxX, pocaVtxY, pocaVtxZ, radial, PRGvtxX, PRGvtxY, PRGvtxZ, PRGradial, pz1, pz2, chi2};
			combtuple->Fill(combtuplearray2);
		}
		// ANALYSE of ALL combined "PIONS" pid check
		for (int l=0;l<combpid.GetLength();++l) {
			// recoil mass calculation
			TLorentzVector mm = ini-combpid[l]->P4();
			Float_t rm=mm.M();
			Float_t pz1=TMath::Abs(combpid[l]->Daughter(0)->P());
			Float_t pz2=TMath::Abs(combpid[l]->Daughter(1)->P());

			// PndVtxPRG Vertex Fitter
			PndVtxPRG prgfitter(combpid[l]);
			prgfitter.Fit();
			TVector3 PRGvtx=combpid[l]->GetFit()->Daughter(0)->GetPosition();
			Float_t chi2=prgfitter.GetChi2();
			Float_t PRGvtxX=PRGvtx.X();
			Float_t PRGvtxY=PRGvtx.Y();
			Float_t PRGvtxZ=PRGvtx.Z();
			Float_t PRGradial;
			PRGradial=PRGvtxX*PRGvtxX+PRGvtxY*PRGvtxY;

			// determine pseudo vertex *** POCA
			PndVtxPoca poca;
			TVector3 pocavtx;
			Float_t pocadistance = poca.GetPocaVtx(pocavtx,combpid[l]);
			Float_t pocaVtxX=pocavtx.X();
			Float_t pocaVtxY=pocavtx.Y();
			Float_t pocaVtxZ=pocavtx.Z();
			Float_t radial;
			radial=pocaVtxX*pocaVtxX+pocaVtxY*pocaVtxY;

			Float_t combtuplearray10[]={nallkaons, nallparticles, nallpions, rm,pocadistance, pocaVtxX, pocaVtxY, pocaVtxZ, radial, PRGvtxX, PRGvtxY, PRGvtxZ, PRGradial, pz1, pz2, chi2};
			pidtuple->Fill(combtuplearray10);
		}

		// ANALYSE of MCMatched pions
		for (int l=0;l<combfalse.GetLength();++l) {
			// recoil mass calculation
			TLorentzVector mm = ini-combfalse[l]->P4();
			Float_t rm=mm.M();
			Float_t pz1=TMath::Abs(combfalse[l]->Daughter(0)->P());
			Float_t pz2=TMath::Abs(combfalse[l]->Daughter(1)->P());

			// PndVtxPRG Vertex Fitter
			PndVtxPRG prgfitter(combfalse[l]);
			prgfitter.Fit();
			TVector3 PRGvtx;
			Float_t chi2=prgfitter.GetChi2();
			Float_t PRGvtxX=PRGvtx.X();
			Float_t PRGvtxY=PRGvtx.Y();
			Float_t PRGvtxZ=PRGvtx.Z();
			Float_t PRGradial;
			PRGradial=PRGvtxX*PRGvtxX+PRGvtxY*PRGvtxY;

			// determine pseudo vertex *** POCA
			PndVtxPoca poca;
			TVector3 pocavtx;
			Float_t pocadistance = poca.GetPocaVtx(pocavtx,combfalse[l]);
			Float_t pocaVtxX=pocavtx.X();
			Float_t pocaVtxY=pocavtx.Y();
			Float_t pocaVtxZ=pocavtx.Z();
			Float_t radial;
			radial=pocaVtxX*pocaVtxX+pocaVtxY*pocaVtxY;

			Float_t combtuplearray9[]={nallkaons, nallparticles, nallpions, rm, pocadistance, pocaVtxX, pocaVtxY, pocaVtxZ, radial, PRGvtxX, PRGvtxY, PRGvtxZ, PRGradial, pz1, pz2, chi2};
			falsetuple->Fill(combtuplearray9);
		}

		// **************** Monte Carlo ************
		// truth match for MC-pi +
		for (Int_t ipiplus=0;ipiplus<mcpiplus.GetLength();++ipiplus){
			RhoCandidate *truth = mcpiplus[ipiplus]->GetMcTruth();
			if (truth && truth !=(RhoCandidate*)0x8011){
				RhoCandidate* motherId = mcpiplus[ipiplus]->GetMcTruth()->TheMother();
				if(motherId && motherId!=(RhoCandidate*)0x10011) {
					if(motherId->PdgCode()==88888) {
						truemcpiplus.Add(mcpiplus[ipiplus]);
					} else {
						falsemcpiplus.Add(mcpiplus[ipiplus]);
					}
				}
			} else {
				falsemcpiplus.Add(mcpiplus[ipiplus]);
			}
		}
		primarymcpions+=truemcpiplus.GetLength();
		// truth match for MC-pi -
		for (Int_t ipiminus=0;ipiminus<mcpiminus.GetLength();++ipiminus){
			RhoCandidate *truth = mcpiminus[ipiminus]->GetMcTruth();
			if (truth && truth !=(RhoCandidate*)0x8011){
				RhoCandidate* motherId = mcpiminus[ipiminus]->GetMcTruth()->TheMother();
				if(motherId && motherId!=(RhoCandidate*)0x10011) {
					if(motherId->PdgCode()==88888) {
						truemcpiminus.Add(mcpiminus[ipiminus]);
					} else {
						falsemcpiminus.Add(mcpiminus[ipiminus]);
					}
				}
			} else {
				falsemcpiminus.Add(mcpiminus[ipiminus]);
			}
		}
		primarymcpions+=truemcpiminus.GetLength();

		// momentum cut ?
		for(int a=0;a<falsemcpiplus.GetLength();a++){
			Float_t pz=falsemcpiplus[a]->Pz();
			Float_t part=5;
			Float_t pzarray[]={pz,part};
			momentumtuple->Fill(pzarray);
		}
		for(int a=0;a<falsemcpiminus.GetLength();a++){
			Float_t pz=falsemcpiminus[a]->Pz();
			Float_t part=5;
			Float_t pzarray[]={pz,part};
			momentumtuple->Fill(pzarray);
		}
		for(int a=0;a<truemcpiplus.GetLength();a++){
			Float_t pz=truemcpiplus[a]->Pz();
			Float_t part=1;
			Float_t pzarray[]={pz,part};
			momentumtuple->Fill(pzarray);
		}
		for(int a=0;a<truemcpiminus.GetLength();a++){
			Float_t pz=truemcpiminus[a]->Pz();
			Float_t part=1;
			Float_t pzarray[]={pz,part};
			momentumtuple->Fill(pzarray);
		}

		// momemtum kaons
		for(int a=0;a<kplus.GetLength();a++){
			Float_t kpz=kplus[a]->Pz();
			Float_t charg=1;
			Float_t kpzarray[]={kpz,charg};
			kaonmomentumtuple->Fill(kpzarray);
		}
		for(int a=0;a<kminus.GetLength();a++){
			Float_t kpz=kminus[a]->Pz();
			Float_t charg=2;
			Float_t kpzarray[]={kpz,charg};
			kaonmomentumtuple->Fill(kpzarray);
		}

		combmctrue.Combine(truemcpiplus,truemcpiminus);
		combmcfalse1.Combine(falsemcpiplus,falsemcpiminus);
		combmcfalse2.Combine(falsemcpiplus,truemcpiminus);
		combmcfalse3.Combine(truemcpiplus,falsemcpiminus);
		// ANALYSE of PRIMARY combined PIONS
		massdifftrue=10000; // mass difference between best missing mass and true mass for h_c^'
		minmassdiffIdx=0;// stores index of best combtrue found
		for (int l=0;l<combmctrue.GetLength();++l) {
			// recoil mass calculation
			TLorentzVector mm = ini-combmctrue[l]->P4();
			Float_t rm=mm.M();
			if (TMath::Abs(rm-mctrk[1]->Mass())<massdifftrue){
				massdifftrue= TMath::Abs(rm-mctrk[1]->Mass());
				minmassdiffIdx=l;
			}
		} // analyse for just the one combined particle
		if(combmctrue.GetLength()>0){
			for(int l=0;l<1;l++){
				// recoil mass calculation
				TLorentzVector mm = ini-combmctrue[minmassdiffIdx]->P4();
				Float_t rm=mm.M();
				Float_t pz1=TMath::Abs(combmctrue[minmassdiffIdx]->Daughter(0)->P());
				Float_t pz2=TMath::Abs(combmctrue[minmassdiffIdx]->Daughter(1)->P());

				// PndVtxPRG Vertex Fitter
				PndVtxPRG prgfitter(combmctrue[minmassdiffIdx]);
				prgfitter.Fit();
				TVector3 PRGvtx=combmctrue[minmassdiffIdx]->GetFit()->Daughter(0)->GetPosition();
				Float_t chi2=prgfitter.GetChi2();
				Float_t PRGvtxX=PRGvtx.X();
				Float_t PRGvtxY=PRGvtx.Y();
				Float_t PRGvtxZ=PRGvtx.Z();
				Float_t PRGradial;
				PRGradial=PRGvtxX*PRGvtxX+PRGvtxY*PRGvtxY;

				// determine pseudo vertex *** POCA
				PndVtxPoca poca;
				TVector3 pocavtx;
				Float_t pocadistance = poca.GetPocaVtx(pocavtx,combmctrue[minmassdiffIdx]);
				Float_t pocaVtxX=pocavtx.X();
				Float_t pocaVtxY=pocavtx.Y();
				Float_t pocaVtxZ=pocavtx.Z();
				Float_t radial;
				radial=pocaVtxX*pocaVtxX+pocaVtxY*pocaVtxY;

				Float_t combtuplearray4[] = {nallkaons, nallparticles, nallpions, rm, pocadistance, pocaVtxX, pocaVtxY, pocaVtxZ, radial, massdifftrue, PRGvtxX, PRGvtxY, PRGvtxZ, PRGradial, pz1, pz2, chi2};
				truemctuple->Fill(combtuplearray4);
		}}
		for (int l=0;l<combmcfalse1.GetLength();++l) {
			// recoil mass calculation
			TLorentzVector mm = ini-combmcfalse1[l]->P4();
			Float_t rm=mm.M();
			Float_t pz1=TMath::Abs(combmcfalse1[l]->Daughter(0)->P());
			Float_t pz2=TMath::Abs(combmcfalse1[l]->Daughter(1)->P());

			// PndVtxPRG Vertex Fitter
			PndVtxPRG prgfitter(combmcfalse1[l]);
			prgfitter.Fit();
			TVector3 PRGvtx=combmcfalse1[l]->GetFit()->Daughter(0)->GetPosition();
			Float_t chi2=prgfitter.GetChi2();
			Float_t PRGvtxX=PRGvtx.X();
			Float_t PRGvtxY=PRGvtx.Y();
			Float_t PRGvtxZ=PRGvtx.Z();
			Float_t PRGradial;
			PRGradial=PRGvtxX*PRGvtxX+PRGvtxY*PRGvtxY;

			// determine pseudo vertex *** POCA
			PndVtxPoca poca;
			TVector3 pocavtx;
			Float_t pocadistance = poca.GetPocaVtx(pocavtx,combmcfalse1[l]);
			Float_t pocaVtxX=pocavtx.X();
			Float_t pocaVtxY=pocavtx.Y();
			Float_t pocaVtxZ=pocavtx.Z();
			Float_t radial;
			radial=pocaVtxX*pocaVtxX+pocaVtxY*pocaVtxY;

			Float_t combtuplearray6[]={nallkaons, nallparticles, nallpions, rm, pocadistance, pocaVtxX, pocaVtxY, pocaVtxZ, radial, PRGvtxX, PRGvtxY, PRGvtxZ, PRGradial, pz1, pz2, chi2};
			falsemctuple->Fill(combtuplearray6);
		}
		for (int l=0;l<combmcfalse2.GetLength();++l) {
			// recoil mass calculation
			TLorentzVector mm = ini-combmcfalse2[l]->P4();
			Float_t rm=mm.M();
			Float_t pz1=TMath::Abs(combmcfalse2[l]->Daughter(0)->P());
			Float_t pz2=TMath::Abs(combmcfalse2[l]->Daughter(1)->P());

			// PndVtxPRG Vertex Fitter
			PndVtxPRG prgfitter(combmcfalse2[l]);
			prgfitter.Fit();
			TVector3 PRGvtx=combmcfalse2[l]->GetFit()->Daughter(0)->GetPosition();
			Float_t chi2=prgfitter.GetChi2();
			Float_t PRGvtxX=PRGvtx.X();
			Float_t PRGvtxY=PRGvtx.Y();
			Float_t PRGvtxZ=PRGvtx.Z();
			Float_t PRGradial;
			PRGradial=PRGvtxX*PRGvtxX+PRGvtxY*PRGvtxY;

			// determine pseudo vertex *** POCA
			PndVtxPoca poca;
			TVector3 pocavtx;
			Float_t pocadistance = poca.GetPocaVtx(pocavtx,combmcfalse2[l]);
			Float_t pocaVtxX=pocavtx.X();
			Float_t pocaVtxY=pocavtx.Y();
			Float_t pocaVtxZ=pocavtx.Z();
			Float_t radial;
			radial=pocaVtxX*pocaVtxX+pocaVtxY*pocaVtxY;

			Float_t combtuplearray7[]={nallkaons, nallparticles, nallpions, rm, pocadistance, pocaVtxX, pocaVtxY, pocaVtxZ, radial, PRGvtxX, PRGvtxY, PRGvtxZ, PRGradial, pz1, pz2, chi2};
			falsemctuple->Fill(combtuplearray7);
		}
		for (int l=0;l<combmcfalse3.GetLength();++l) {
			// recoil mass calculation
			TLorentzVector mm = ini-combmcfalse3[l]->P4();
			Float_t rm=mm.M();
			Float_t pz1=TMath::Abs(combmcfalse3[l]->Daughter(0)->P());
			Float_t pz2=TMath::Abs(combmcfalse3[l]->Daughter(1)->P());

			// PndVtxPRG Vertex Fitter
			PndVtxPRG prgfitter(combmcfalse3[l]);
			prgfitter.Fit();
			TVector3 PRGvtx=combmcfalse3[l]->GetFit()->Daughter(0)->GetPosition();
			Float_t chi2=prgfitter.GetChi2();
			Float_t PRGvtxX=PRGvtx.X();
			Float_t PRGvtxY=PRGvtx.Y();
			Float_t PRGvtxZ=PRGvtx.Z();
			Float_t PRGradial;
			PRGradial=PRGvtxX*PRGvtxX+PRGvtxY*PRGvtxY;

			// determine pseudo vertex *** POCA
			PndVtxPoca poca;
			TVector3 pocavtx;
			Float_t pocadistance = poca.GetPocaVtx(pocavtx,combmcfalse3[l]);
			Float_t pocaVtxX=pocavtx.X();
			Float_t pocaVtxY=pocavtx.Y();
			Float_t pocaVtxZ=pocavtx.Z();
			Float_t radial;
			radial=pocaVtxX*pocaVtxX+pocaVtxY*pocaVtxY;

			Float_t combtuplearray8[]={nallkaons, nallparticles, nallpions, rm, pocadistance, pocaVtxX, pocaVtxY, pocaVtxZ, radial, PRGvtxX, PRGvtxY, PRGvtxZ, PRGradial, pz1, pz2, chi2};
			falsemctuple->Fill(combtuplearray8);
		}
	} // end of event loop

	//	float erg=(detectpions-pionskicked)/mcpions*100;
	//	cout << "Number of MC pions:       " << mcpions << endl << endl;
	//	cout << "Number of detected pions: " << detectpions << endl;
//		cout << "Number of kicked pions:  - " << pionskicked << endl;
	//	cout << "                         ------" << endl;
	//	cout << "Number of pions left    : " << detectpions-pionskicked << "=> " << erg << "%" << endl;
	//	cout << "Number of primary pions:" << endl;
	//	cout << "-MC:       " << primarymcpions << endl;
	//	cout << "-detected: " << primarydetectedpions << endl;
		cout << "kaons found in all events: " << k0kick << endl;
//		cout << "number of kaons" << nallkaons << endl;

	out->cd();
	nkaonstight->Write();
	nkaons->Write();
	npart->Write();
	npions->Write();
	k0im->Write();
//	nkaonsandk0->Write();
	kaonposz->Write();

	truetuple->Write();
	combtuple->Write();
	pidtuple->Write();
	falsetuple->Write();
	truemctuple->Write();
	falsemctuple->Write();
	momentumtuple->Write();
	kaonmomentumtuple->Write();
	out->Save();

	// -----   Finish   -------------------------------------------------------
	timer.Stop();
	Double_t rtime = timer.RealTime();
	Double_t ctime = timer.CpuTime();
	cout << endl;
	cout << "Macro finished successfully." << endl;
	cout << "Output file is "    << OutFile << endl;
	cout << "Real time " << rtime << " s, CPU time " << ctime << " s" << endl;
	cout << endl;
	cout << " Test passed" << endl;
	cout << " All ok " << endl;
	exit(0);
}
