void plot_info (Long_t distcut=1000, Long_t zcut=5000, Long_t radcut=2000, Long_t sub) {
	TPad *extrapad=new TPad("extrapad","", 0.12,0.7,0.44,0.89);
//	TPad *extrapad=new TPad("extrapad","", 0.55,0.7,0.9,0.89);
	extrapad->SetBorderMode(0);
	extrapad->Draw();
	extrapad->cd();
	TPaveText *myText = new TPaveText(0.05,0.05,0.93,0.95);
	if(sub==1){
		TString box0="without any cut";
		TString box1="";
		TString box2="";
		TString box3="";
	}
	if(sub==2){
		TString boxS="(1)";
		TString box0="with distance cut";
		TString box1="distcut:    "; box1+=distcut; box1+=" mm";
		TString box2="";
		TString box3="";
	}
	if(sub==3){
		TString boxS="(2)";
		TString box0="with distance \& z cut";
		TString box1="distcut:    "; box1+=distcut; box1+=" mm";
		TString box2="zcut:    "; box2+=zcut; box2+=" mm";
		TString box3="";
	}
	if(sub==4){
		TString boxS="(3)";
		TString box0="with all cuts";
		TString box1="distcut:    "; box1+=distcut; box1+=" mm";
		TString box2="zcut:    "; box2+=zcut; box2+=" mm";
		TString box3="radialcut:   0."; box3+=radcut; box3+=" mm";
	}
	myText->SetTextSize(0.18);
	myText->AddText(box0);
	myText->SetTextAlign(32);
	myText->AddText(box1);
	myText->AddText(box2);
	myText->AddText(box3);
	if(sub!=1) myText->AddText(0.13,0.53,boxS);
	myText->Draw();
}

void plot(int what=1, Long_t distcut=20, Long_t zcut=9, Long_t radcut=5, Long_t nallparticlescut=14, Long_t pz=550) {
	TString auswahl="prg";
//	cout << "'poca' or 'prg': ";
//	cin >> auswahl;
TFile *f1 = new TFile("output_psi2sana.root","UPDATE");
TTree *Content;
TTree *Content2;
TTree *Content3;
TTree *Content4;
f1->GetObject("truetuple", Content);  // what=1   primary
f1->GetObject("combtuple", Content2); // what=2   all
f1->GetObject("pidtuple", Content3);  // what=3   mctruth
f1->GetObject("truemctuple", Content4);  // what=4   all mighty

//TButton *but1=new TButton("+10","plot(zcut+10);",.15,.92,.29,.98);
//TButton *but2=new TButton("-10","plot(zcut-10)",.01,.92,.14,.98);
//gStyle->SetOptStat(0);

	TString c2;
	TCut s2;
// cut 1
	TString c1="pocadistance<";
	c1+=distcut;
	c1+="/10";
	TCut s1=c1;

// cut 2 - z
if (auswahl=="poca"){
	c2=c1;
	c2+=" && pocaVtxZ<";
	c2+=zcut;
	c2+="/10 && pocaVtxZ>-";
	c2+=zcut;
	c2+="/10";
	s2=c2;}
if (auswahl=="prg"){
	c2="";
	c2+="PRGvtxZ<";
	c2+=zcut;
	c2+="/10 && PRGvtxZ>-";
	c2+=zcut;
	c2+="/10";
	s2=c2;}

// cut 3 - radial
	Long_t radcut2;
	radcut2=radcut*radcut;
	TString c3=c2;
	if (auswahl=="poca") c3+=" && radial<";
	if (auswahl=="prg")	c3+=" && PRGradial<";
	c3+=radcut2;
	c3+="/100";
	TCut s3=c3;

// cut 4 - number of particles
	TString c4=c3;
	c4+=" && nallparticles>";
	c4+=nallparticlescut;
	TCut s4=c4;

// cut 5 - z momentum
	TString c5=c4;
	c5+=" && pz1<";
	c5+=pz;
	c5+="/100 && pz2<";
	c5+=pz;
	c5+="/100";
	TCut s5=c5;

// cut 6 - number of kaons
	TString c6=c5;
	c6+=" && nallkaons>=0";
	TCut s6=c6;

// cut 7 - number of pions
	TString c7=c6;
	c7+=" && nallpions>0";
	TCut s7=c7;

// histo name
	Long_t longcut; longcut=zcut*10;
	TString hname;
	hname="Recoil Mass at ";
	hname=hname+(zcut/10);
	hname=hname+"mm-Cut";


TCanvas *ch1 = new TCanvas("ch1","");
// create histograms
TH1F *histo = new TH1F("histo", "", 100, 3, 5.2);    // pid matched pions - no cut
	histo->SetXTitle("Recoil Mass (GeV/c^2)");
	histo->SetYTitle("counts");
	histo->SetLineColor(1); // black
	Content->Draw("rm>>histo","");
//	if (what==2) Content->Draw("rm>>histo","");

TH1F *histoA  = new TH1F("histoA", "", 100, 3, 5.2); // true primary pions - no cut
	histoA->SetXTitle("Recoil Mass (GeV/c^2)");
	histoA->SetYTitle("counts");
	histoA->SetLineColor(2); // red
	if (what==1) Content->Draw("rm>>histoA","");
	if (what==2) Content2->Draw("rm>>histoA","");
	if (what==3) Content3->Draw("rm>>histoA","");
	if (what==4) Content4->Draw("rm>>histoA","");

TH1F *histoB = new TH1F ("histoB", "", 100, 3, 5.2); // distance-cut
	histoB->SetXTitle("Recoil Mass (GeV/c^2)");
	histoB->SetYTitle("counts");
	histoB->SetLineColor(4); // blue
	if (what==1) Content->Draw("rm>>histoB",s1);
	if (what==2) Content2->Draw("rm>>histoB",s1);
	if (what==3) Content3->Draw("rm>>histoB",s1);
	if (what==4) Content4->Draw("rm>>histoB",s1);

TH1F *histoC = new TH1F ("histoC", "", 100, 3, 5.2); // distance-cut + z-cut
	histoC->SetXTitle("Recoil Mass (GeV/c^2)");
	histoC->SetYTitle("counts");
	histoC->SetLineColor(4); // blue
	if (what==1) Content->Draw("rm>>histoC",s2);
	if (what==2) Content2->Draw("rm>>histoC",s2);
	if (what==3) Content3->Draw("rm>>histoC",s2);
	if (what==4) Content4->Draw("rm>>histoC",s2);

TH1F *histoD = new TH1F ("histoD", "", 100, 3, 5.2); // distance-cut + z-cut + radial-cut
	histoD->SetXTitle("Recoil Mass (GeV/c^2)");
	histoD->SetYTitle("counts");
	histoD->SetLineColor(4); // blue
	if (what==1) Content->Draw("rm>>histoD",s7);
	if (what==2) Content2->Draw("rm>>histoD",s7);
	if (what==3) Content3->Draw("rm>>histoD",s7);
	if (what==4) Content4->Draw("rm>>histoD",s7);
//TH1F *histoZ2 = new TH1F ("histoZ2", "", 1000, -0.2, 3);
//	histoZ2->SetLineColor(2);
//	Content->Draw("pocadistance>>histoZ2","");
//TH1F *histoZ = new TH1F ("histoZ", "", 1000, -0.2, 3);
//	histoZ->SetYTitle("counts   ");
//	histoZ->SetXTitle("Distance of Tracks (cm)");
////	histoZ->SetTitle("All Pions (blue) to Primary Pions (red)");
//	Content3->Draw("pocadistance>>histoZ","");
//	histoZ2->Draw("same");
//	TLine *l1=new TLine(2,0,2,2500);
//	l1->Draw();
//	TLine *l2=new TLine(-2,0,-2,4000);
//	l2->Draw();
	ch1->Close();



	TCanvas *mycanvas1 = new TCanvas("mycanvas1","Recoil Mass1",10,40,900,800);
	histo->Draw();
	histoA->Draw("same");
	if(histoA->GetMaximum()>histo->GetMaximum()) {histoA->Draw();histo->Draw("same");}
	plot_info(distcut, zcut, radcut, 1);
//	if(what==1) mycanvas1->SaveAs("plots/plot_true_1.pdf");
//	if(what==2) mycanvas1->SaveAs("plots/plot_all_1.pdf");
//	if(what==3) mycanvas1->SaveAs("plots/plot_pid_1.pdf");
	mycanvas1->Close();

	TCanvas *mycanvas2 = new TCanvas("mycanvas2","Recoil Mass2",10,40,900,800);
//	histoB->Draw();
	histoA->Draw();
	histoB->Draw("same");
	if(histoB->GetMaximum()>histoA->GetMaximum()) {histoB->Draw();histoA->Draw("same");}
	plot_info(distcut, zcut, radcut, 2);
//	if(what==1) mycanvas2->SaveAs("plots/plot_true_2.pdf");
//	if(what==2) mycanvas2->SaveAs("plots/plot_all_2.pdf");
//	if(what==3) mycanvas2->SaveAs("plots/plot_pid_2.pdf");
	mycanvas2->Close();

	TCanvas *mycanvas3 = new TCanvas("mycanvas3","Recoil Mass3",10,40,900,800);
//	histoC->Draw();
	histoA->Draw();
	histoC->Draw("same");
	if(histoC->GetMaximum()>histoA->GetMaximum()) {histoC->Draw();histoA->Draw("same");}
	plot_info(distcut, zcut, radcut, 3);
//	if(what==1) mycanvas3->SaveAs("plots/plot_true_3.pdf");
//	if(what==2) mycanvas3->SaveAs("plots/plot_all_3.pdf");
//	if(what==3) mycanvas3->SaveAs("plots/plot_pid_3.pdf");
	mycanvas3->Close();

	TCanvas *mycanvas4 = new TCanvas("mycanvas4","Recoil Mass4",10,40,900,800);
	histoD->Draw();
//	histoD->Draw("same");
//	histo->Draw("same");
//	Content->Draw("rm>>histoC",s3,"same");
//	if(histoD->GetMaximum()>histoA->GetMaximum()) {histoD->Draw();histoA->Draw("same");}
//	plot_info(distcut, zcut, radcut, 4);

//	histoD->Fit("landau","","",3.9,4.4);

	// efficiency
	Double_t x=0,x1=0,x2=0;
	for(int c=72;c<143;c++) {
		x1+=histoD->GetBinContent(c);
	}
	for(int c=72;c<143;c++) {
		x2+=histoA->GetBinContent(c);
	}
	x=x1/x2;
	cout << "Cut-Efficiency: " << x << endl;

//	if(what==1) mycanvas4->SaveAs("plots/plot_true_4.pdf");
//	if(what==2) mycanvas4->SaveAs("plots/plot_all_4.pdf");
//	if(what==3) mycanvas4->SaveAs("plots/plot_pid_4.pdf");
//	mycanvas4->Close();

//but1->Draw();
//but2->Draw();
/*
Double_t minx=histo->GetXaxis()->GetXmin();
Double_t maxx=histo->GetXaxis()->GetXmax();
Double_t maxy=histoA->GetMaximum();
Int_t binmax=histo->GetMaximumBin();
Int_t maxbin=histo->GetBinContent(binmax);

TLine *l1=new TLine(3.934,0,3.934,maxy);
TLine *l2=new TLine(minx,maxbin,maxx,maxbin);
l1->SetLineColor(15);
l1->SetLineWidth(2);
l1->Draw();
l2->SetLineWidth(1);
l2->Draw();
//histoA->Write();
//histo->Write();
//mycanvas->Write();*/
//f1->Close();
}
