#!/bin/bash

if [ "$check" = "1" ];
then

# special settings to compile pluto with gcc 4.0.X
export FRIENDFLAG=""

if [ "$compiler" = "gcc" ];
then
GCC_MAJOR=$(gcc -dumpversion | cut -c 1)
GCC_MINOR=$(gcc -dumpversion | cut -c 3)
if [ "$GCC_MAJOR" = "4" ]; 
then
if [ "$GCC_MINOR" != "0" ]; 
then
export FRIENDFLAG="-ffriend-injection"
fi
fi
fi

if [ "$make_install" = "yes" ]; 
then
install_prefix=$SIMPATH_INSTALL
else
install_prefix=$SIMPATH
fi

checkfile=$install_prefix/lib/libPluto.so
echo "THE PATH IS $install_prefix"

if (not_there $checkfile);
then 
cd $install_prefix
case $PLUTOVERSION in
*5.4*)  echo Compiling v5.4x Pluto Version
cp Makefile.fairsoft Makefile
;;

#We can add more here later
esac

if [ "$compiler" = "intel" ];
then
mysed 'g++' 'icpc' Makefile 
fi
mysed "CXXFLAGS      = -Wall" "CXXFLAGS      = -Wall ${CXXFLAGS}"  Makefile
if [ "$platform" = "macosx" ];
then
mysed  '-g -shared -Wl,-soname,$@' ' -dynamiclib -flat_namespace -single_module -undefined dynamic_lookup' Makefile
mysed  'LIBSO = libPluto.so' 'LIBSO = libPluto.dylib' Makefile
fi
if [ "$system" = "64bit" ];
then
mysed 'SOFLAGS       =' 'SOFLAGS       = -m64' Makefile
mysed 'CXXFLAGS      = -Wall' 'CXXFLAGS      = -Wall -m64' Makefile
fi

echo "Getting Ready to make PLUTO++"

make

else 
echo "PLUTO already has libPluto.so built. To Rebuild delete $checkfile and installer again"

fi
fi

cd $install_prefix

return 1