#!/bin/bash
# Uses the tool uname to check on which system
# the script is run 
# The script is inspired by the configure script
# from ROOT

#REMOVE AFTER DEBUGGED
#datum=$(date +%d%m%y_%H%M%S)
#logfile=$PWD/Install_$datum.log
#logfile_lib=$PWD/libraries_$datum.log
#echo "The build process for the external packages for the FairRoot Project was started at" $datum | tee -a $logfile

#compiler=gcc
##########


arch=`uname -s | tr '[A-Z]' '[a-z]'`
chip=`uname -m | tr '[A-Z]' '[a-z]'`

#work around for using icecc 
ncpu=`echo $NCPU`
if [ "$ncpu" != "" ];
then
 number_of_processors=$ncpu
  echo "Number of proccessors = $NCPU "
# get the number of processors
elif [ "$arch" = "linux" ];
then
  number_of_processors=$(cat /proc/cpuinfo | grep processor | wc -l)
elif [ "$arch" = "darwin" ];
then
  number_of_processors=$(sysctl -n hw.ncpu)
#$(sysctl -n hw.ncpu)
elif [ "$arch" = "sunos" ];
then
  number_of_processors=$(/usr/sbin/psrinfo | wc -l)
fi

number_of_processes=$number_of_processors

#echo $arch "   " $chip "  "  $compiler"  "$number_of_processors

case "$arch:$chip:$compiler" in
    linux:ia64:gcc)          
        arch=linuxia64gcc    
        platform=linux
        PLATFORM=$platform
        system=64bit
        MAKE_command=make
	checklib64="yes" 
        ;;
    linux:ia64:intel) 
        echo "The Intel compiler is not supported for Itanium"
        exit 1         
        #arch=linuxia64gcc    
        #platform=linux
        #PLATFORM=$platform
        #system=64bit
        #MAKE_command=make
        ;;
    linux:x86_64:gcc)        
        arch=linuxx8664gcc   
        platform=linux
        PLATFORM=$platform
        system=64bit
        MAKE_command=make
	checklib64="yes" 
        ;;
    linux:x86_64:intel)        
        arch=linuxx8664icc   
        platform=linux
        PLATFORM=$platform
        system=64bit
        MAKE_command=make
	checklib64="yes" 
        ;;
    linux:i*86:gcc)          
        arch=linux           
        platform=linux
        PLATFORM=$platform
        system=32bit
        MAKE_command=make
        ;;
    linux:i*86:intel)          
        arch=linuxicc           
        platform=linux
        PLATFORM=$platform
        system=32bit
        MAKE_command=make
        ;;
    darwin:*86*:gcc)         
        arch=macosx          
        platform=macosx
        PLATFORM=$platform
        system=32bit
        MAKE_command=make
        ;;
     sunos:*86*:CC)
        arch=solarisCC5
        platform=solaris
        PLATFORM=$platform
        system=64bit
        MAKE_command=gmake
	checklib64="yes" 
        ;;      
    sunos:*86*:gcc)
        arch=solarisgcc
        platform=solaris
        PLATFORM=$platform
        system=64bit
        MAKE_command=gmake
	checklib64="yes"    
        ;;
    *)
        echo "This architecture is not supported up to now"
        echo "Please contact the FairRoot team at GSI"
        echo "http://fairroot.gsi.de"
#exit 1
        ;;
esac



is_in_path make   
   result=$?
if [ "$result" = "0" ]; then
    echo "Checking for GNU Make: make is not found"
    install_make=yes
else
    echo "Checking for GNU Make:  " | tee -a $logfile
fi


if [ "$arch" = "macosx" ]; then
   if [ `sw_vers | sed -n 's/ProductVersion://p' | cut -d . -f 2` -ge 5 ]; then
      if `sysctl machdep.cpu.extfeatures | grep "64" > /dev/null  2>&1` ; then
         arch=macosx64
         platform=macosx
         PLATFORM=$platform
         system=64bit
         MAKE_command=make
	 checklib64="yes" 
      fi
   fi
fi

#echo "system is $system"
return 1

