#!/bin/bash 
#
#Script to install PLUTO on any UNIX system
# Inspired by the
# CBM package compilation script
# mkunkel@jlab.org, August 2012
# update of the script
# include debug version and 
# intel compiler switches
# debug options on :set -xv
# debug options off:set +xv
# 
set +xv

# define the logfile
datum=$(date +%d%m%y_%H%M%S)
logfile=$PWD/Install_$datum.log
logfile_lib=$PWD/libraries_$datum.log
echo "The build process for the external packages for the FairRoot Project was started at" $datum | tee -a $logfile

source scripts/functions.sh
#Get some input interactively.
source scripts/menu.sh
   
# check the architecture automatically
source scripts/check_system.sh

# set the compiler options according to architecture, compiler
# debug and optimization options
source scripts/set_compiler.sh

echo "The following parameters are set." | tee -a $logfile
echo "System              : " $system | tee -a $logfile
echo "C++ compiler        : " $CXX | tee -a $logfile
echo "C compiler          : " $CC | tee -a $logfile
echo "Fortran compiler    : " $FC | tee -a $logfile
echo "CXXFLAGS            : " $CXXFLAGS | tee -a $logfile
echo "CFLAGS              : " $CFLAGS | tee -a $logfile
echo "Compiler            : " $compiler | tee -a $logfile
echo "Fortran compiler    : " $FC
echo "Debug               : " $debug | tee -a $logfile
echo "Optimization        : " $optimize | tee -a $logfile
echo "Platform            : " $platform | tee -a $logfile
echo "Architecture        : " $arch | tee -a $logfile
echo "processes for build : " $number_of_processes | tee -a $logfile

#exit 1
# Set our base directory
cd ..
export SIMPATH=$PWD
#echo $SIMPATH "path to install"
cd -

check=1

# set the versions of packages to be build
source scripts/package_versions.sh

# Now start compilations with checks

###################### CMake ################################
# This is only for safety reasons. If we find a machine where
# cmake is not installed, we install cmake and add the path 
# to the environment variable PATH

#if [ "$check" = "1" ];
#then
#  source scripts/install_cmake.sh
#fi


##################### Pluto #############################################

if [ "$check" = "1" ];
then
echo "will install PLUTO++ here"
ls
source scripts/install_pluto.sh
fi

if [ "$check" = "1" ];
then
    echo "*** End installation of external packages without Errors***"  | tee -a $logfile
#exit 0    
else
    echo "*** End installation of external packages with Errors***"  | tee -a $logfile
#exit 42
fi	
