#!/bin/bash
# checks for existence of compiler and set the correct
# environment variables
# The only compiler supported up to now are the 
# GNU compiler collection and the Intel compiler suite

#setting the default language (from Andery Sokolov)
default_lang=$(echo $LANG)
LANG=en_EN.utf-8


if [ "$compiler" = "gcc" ];
then
  #check compiler version. If major version < 3 then stop
  gcc_major_version=$(gcc -dumpversion | cut -c 1)
  if [ $gcc_major_version -lt 3 ];
  then
    echo "Your gcc $(gcc -dumpversion) is prior major release 3." 
    echo "This compiler can't compile the code."
    echo "Please update your compiler or choose another one."
    echo "Stop script at this point"
    exit 1
  fi

  is_in_path g++   
  result=$?
  if [ "$result" = "0" ]; then
      echo "Could not find C++ compiler" 
      install_cxx=yes
  else
      echo "C++ compiler found in PATH" | tee -a $logfile
  fi
    
  is_in_path gfortran
  result=$?
  if [ "$result" = "1" ];
  then
      fortran_compiler=gfortran
  else
    is_in_path g77
    result=$?
    if [ "$result" = "1" ];
    then    
      fortran_compiler=g77
    else
      echo "Could not find any fortran compiler. There is neither g77 nor"
      echo "gfortran in PATH"
      echo "Stop script at this point"
      install_fortran=yes
    fi
  fi
  
  if [ "$install_fortran" = "yes" ]; then 
     exit 1 
  fi
  
  if [ "$install_cxx" = "yes" ]; then 
     exit 1 
  fi
  
  export FC=$fortran_compiler
  export F77=$fortran_compiler

elif [ "$compiler" = "intel" ];
then
  if [ "$platform" = "linux" ];
  then
  # check if intel compilers (icc, ifort) exists in $PATH
  # if the choosen compiler is intel
    icc_exist=$(icc --version | grep ICC | cut -c 1-3)
    ifort_exist=$(ifort --version | grep IFORT | cut -c 1-5)
    if [ "$icc_exist"  = "icc" -a "$ifort_exist"  = "ifort" ];
    then
      echo "Found Intel Fortran an C++ compilers in PATH" | tee -a $logfile
      . iccvars.sh
      . ifortvars.sh
      icc_test=$(icc --version | grep ICC | cut -c 11-12)
      export icc_version=$icc_test
      export FC=ifort
      export F77=ifort
    else
      echo "-EE- Intel C++ or Fortran compiler not found in PATH" | tee -a $logfile
      echo "-EE- Please use a different compiler in the menu." | tee -a $logfile
      echo "-EE- Exit script." | tee -a $logfile
      exit 
    fi
  elif [ "$platform" = "macosx" ];
  then
    echo "The Intel compilers are not supported for Mac OS X up to now"
    echo "Please choose a different compiler"
    echo "Stop the script now"
    exit 1
  fi
elif [ "$compiler" = "CC" ];
then
  fortran_compiler=f77
  export FC=$fortran_compiler
  export F77=$fortran_compiler
fi

case "$platform:$compiler:$debug:$optimize" in
  linux:gcc:yes:no)
    export CXX=g++
    export CC=gcc
    export CFLAGS="-g -O0"
    geant4_system=Linux-g++
    echo "*** Compiling the external packages with the GCC compiler" | tee -a $logfile
    echo "*** Building the libraries with debug information" | tee -a $logfile
    ;;
  linux:gcc:no:no)
    export CXX=g++
    export CC=gcc
    export CFLAGS="-O2"
    geant4_system=Linux-g++
    echo "*** Compiling the external packages with the GCC compiler" | tee -a $logfile
    echo "*** Building the libraries with optimization" | tee -a $logfile
    ;;
  linux:gcc:no:yes)
    export CXX=g++
    export CC=gcc
    export CFLAGS="-O3" # -march=native"
    geant4_system=Linux-g++
    echo "*** Compiling the external packages with the GCC compiler" | tee -a $logfile
    echo "*** Building the libraries with best optimization" | tee -a $logfile
    ;;
  linux:intel:yes:no)
    export CXX=icpc
    export CC=icc
    export CFLAGS="-g -O0"
    geant4_system=Linux-icc
    echo "*** Compiling the external packages with the Intel compiler" | tee -a $logfile
    echo "*** Building the libraries with debug information" | tee -a $logfile
    ;;
  linux:intel:no:no)  
    export CXX=icpc
    export CC=icc
    export CFLAGS="-O2"
    geant4_system=Linux-icc
    echo "*** Compiling the external packages with the Intel Compiler" | tee -a $logfile
    echo "*** Building the libraries with optimization" | tee -a $logfile
    ;;
  linux:intel:no:yes) 
    export CXX=icpc
    export CC=icc
    export CFLAGS="-O3 -mtune=pentium4 -xN -axN"
    geant4_system=Linux-icc
    echo "*** Compiling the external packages with the Intel Compiler" | tee -a $logfile
    echo "*** Building the libraries with best optimization" | tee -a $logfile
    ;;  
  macosx:gcc:yes:no)
    export CXX=g++
    export CC=gcc
    export CFLAGS="-g -O0"
    geant4_system=Darwin-g++
    echo "*** Compiling the external packages with the GCC compiler" | tee -a $logfile
    echo "*** Building the libraries with debug information" | tee -a $logfile
    ;;
  macosx:gcc:no:no)
    export CXX=g++
    export CC=gcc
    export CFLAGS="-O2"
    geant4_system=Darwin-g++
    echo "*** Compiling the external packages with the GCC compiler" | tee -a $logfile
    echo "*** Building the libraries with optimization" | tee -a $logfile
    ;;
  macosx:gcc:no:yes)
    export CXX=g++
    export CC=gcc
    export CFLAGS="-O3 "  #-march=pentium4"
    geant4_system=Darwin-g++
    echo "*** Compiling the external packages with the GCC compiler" | tee -a $logfile
    echo "*** Building the libraries with best optimization" | tee -a $logfile
    ;;
  macosx:intel:*:*)
    echo "The Intel compilers are not supported for Mac OS X up to now"
    echo "Please choose a different compiler"
    echo "Stop the script now"
    exit 
    ;;
  solaris:CC:yes:no)
    export CXX=CC
    export CC=cc
    export CFLAGS="-g -O0"
    geant4_system=SUN-CC
    echo "*** Compiling the external packages with the CC compiler" | tee -a $logfile
    echo "*** Building the libraries with debug information" | tee -a $logfile
    ;;
  solaris:CC:no:no)
    export CXX=CC
    export CC=cc
    export CFLAGS="-O2"
    geant4_system=SUN-CC
    echo "*** Compiling the external packages with the CC compiler" | tee -a $logfile
    echo "*** Building the libraries with optimization" | tee -a $logfile
    ;;
  solaris:CC:no:yes)
    export CXX=CC
    export CC=cc
    export CFLAGS="-O3 " #-march=pentium4"
    geant4_system=SUN-CC
    echo "*** Compiling the external packages with the CC compiler" | tee -a $logfile
    echo "*** Building the libraries with best optimization" | tee -a $logfile
    ;;  
  solaris:gcc:yes:no)
    export CXX=g++
    export CC=gcc
    export CFLAGS="-g -O0"
    geant4_system=SUN-gcc
    echo "*** Compiling the external packages with the GCC compiler" | tee -a $logfile
    echo "*** Building the libraries with debug information" | tee -a $logfile
    ;;
  solaris:gcc:no:no)
    export CXX=g++
    export CC=gcc
    export CFLAGS="-O2"
    geant4_system=SUN-gcc
    echo "*** Compiling the external packages with the GCC compiler" | tee -a $logfile
    echo "*** Building the libraries with optimization" | tee -a $logfile
    ;;
  solaris:gcc:no:yes)
    export CXX=gcc
    export CC=g++
    export CFLAGS="-O3 " #-march=pentium4"
    geant4_system=SUN-gcc
    echo "*** Compiling the external packages with the GCC compiler" | tee -a $logfile
    echo "*** Building the libraries with best optimization" | tee -a $logfile
    ;;    
  *)
    echo "This platform or the compiler are not supported"
    echo "Stop the script now"
    exit 
    ;;
esac

export CXXFLAGS=${CFLAGS} 
export FFLAGS=${CFLAGS}

#restore the default langauge
export LANG=${default_lang}

return 1
