#!/bin/bash 
#
# CBM package compilation script
# m.al-turany@gsi.de, June 2006
# protopop@jlab.org, June 2006
# update of the script
# include debug version and 
# intel compiler switches
# f.uhlig@gsi.de, July 2007

# debug options on :set -xv
# debug options off:set +xv
# 
set +xv

# define the logfile
datum=$(date +%d%m%y_%H%M%S)
logfile=$PWD/Install_$datum.log
logfile_lib=$PWD/libraries_$datum.log
echo "The build process for the external packages for the FairRoot Project was started at" $datum | tee -a $logfile

source scripts/functions.sh

# check if there was a parameter given to the script.
# if yes then use some standard parameters and don't
# show the menues. Else get some input interactively.
if [ $# == "0" ];
then

  source scripts/menu.sh
 
else
  if [ $1 = "automatic" ];
  then
    compiler=gcc
    debug=yes
    optimize=no
    geant4_data_files=yes
    geant4_get_data=yes
    make_install=yes
    SIMPATH_INSTALL=$PWD/install
  elif [ $1 = "grid" ];
  then
    compiler=gcc
    debug=no
    optimize=no
    geant4_data_files=yes
    geant4_get_data=yes
    build_for_grid=yes
  else
    echo "Parameter given to the script is not known."
    echo "The only valid parameter up to now is automatic."
    echo "Stop execution at this point."
    exit 42
  fi   
fi  
  
# check the architecture automatically
source scripts/check_system.sh

# set the compiler options according to architecture, compiler
# debug and optimization options
source scripts/set_compiler.sh

echo "The following parameters are set." | tee -a $logfile
echo "System              : " $system | tee -a $logfile
echo "C++ compiler        : " $CXX | tee -a $logfile
echo "C compiler          : " $CC | tee -a $logfile
echo "Fortran compiler    : " $FC | tee -a $logfile
echo "CXXFLAGS            : " $CXXFLAGS | tee -a $logfile
echo "CFLAGS              : " $CFLAGS | tee -a $logfile
echo "Compiler            : " $compiler | tee -a $logfile
echo "Fortran compiler    : " $FC
echo "Debug               : " $debug | tee -a $logfile
echo "Optimization        : " $optimize | tee -a $logfile
echo "Platform            : " $platform | tee -a $logfile
echo "Architecture        : " $arch | tee -a $logfile
echo "G4System            : " $geant4_system | tee -a $logfile
echo "g4_data_files       : " $geant4_data_files | tee -a $logfile
echo "g4_get_data         : " $geant4_get_data | tee -a $logfile
echo "Number of parallel    " | tee -a $logfile
echo "processes for build : " $number_of_processes | tee -a $logfile

#exit 1
# Set our base directory
export SIMPATH=$PWD

check=1

# set the versions of packages to be build
source scripts/package_versions.sh

# Now start compilations with checks

###################### CMake ################################
# This is only for safety reasons. If we find a machine where
# cmake is not installed, we install cmake and add the path 
# to the environment variable PATH

#if [ "$check" = "1" ];
#then
#  source scripts/install_cmake.sh
#fi


##################### Pluto #############################################

if [ "$check" = "1" ];
then
  source scripts/install_pluto.sh
fi

if [ "$check" = "1" ];
then
    echo "*** End installation of external packages without Errors***"  | tee -a $logfile
    exit 0    
else
    echo "*** End installation of external packages with Errors***"  | tee -a $logfile
    exit 42
fi	
