#!/bin/bash
# Uses the tool uname to check on which system
# the script is run 
# The script is inspired by the configure script
# from ROOT




arch=`uname -s | tr '[A-Z]' '[a-z]'`
chip=`uname -m | tr '[A-Z]' '[a-z]'`

#work around for using icecc 
ncpu=`echo $NCPU`
if [ "$ncpu" != "" ];
then
 number_of_processors=$ncpu
  echo "Number of proccessors = $NCPU "
# get the number of processors
elif [ "$arch" = "linux" ];
then
  number_of_processors=$(cat /proc/cpuinfo | grep processor | wc -l)
elif [ "$arch" = "darwin" ];
then
  number_of_processors=$(sysctl -n hw.ncpu)
elif [ "$arch" = "sunos" ];
then
  number_of_processors=$(/usr/sbin/psrinfo | wc -l)
fi

number_of_processes=$number_of_processors



case "$arch:$chip:$compiler" in
    linux:ia64:gcc)          
        arch=linuxia64gcc    
        platform=linux
        PLATFORM=$platform
        system=64bit
        MAKE_command=make
	checklib64="yes" 
        ;;
    linux:ia64:intel) 
        echo "The Intel compiler is not supported for Itanium"
        exit 1         
        #arch=linuxia64gcc    
        #platform=linux
        #PLATFORM=$platform
        #system=64bit
        #MAKE_command=make
        ;;
    linux:x86_64:gcc)        
        arch=linuxx8664gcc   
        platform=linux
        PLATFORM=$platform
        system=64bit
        MAKE_command=make
	checklib64="yes" 
        ;;
    linux:x86_64:intel)        
        arch=linuxx8664icc   
        platform=linux
        PLATFORM=$platform
        system=64bit
        MAKE_command=make
	checklib64="yes" 
        ;;
    linux:i*86:gcc)          
        arch=linux           
        platform=linux
        PLATFORM=$platform
        system=32bit
        MAKE_command=make
        ;;
    linux:i*86:intel)          
        arch=linuxicc           
        platform=linux
        PLATFORM=$platform
        system=32bit
        MAKE_command=make
        ;;
    darwin:*86*:gcc)         
        arch=macosx          
        platform=macosx
        PLATFORM=$platform
        system=32bit
        MAKE_command=make
        ;;
     sunos:*86*:CC)
        arch=solarisCC5
        platform=solaris
        PLATFORM=$platform
        system=64bit
        MAKE_command=gmake
	checklib64="yes" 
        ;;      
    sunos:*86*:gcc)
        arch=solarisgcc
        platform=solaris
        PLATFORM=$platform
        system=64bit
        MAKE_command=gmake
	checklib64="yes"    
        ;;
    *)
        echo "This architecture is not supported up to now"
        echo "Please contact the FairRoot team at GSI"
        echo "http://fairroot.gsi.de"
        exit 1
        ;;
esac



is_in_path make   
   result=$?
if [ "$result" = "0" ]; then
    echo "Checking for GNU Make: make is not found"
    install_make=yes
else
    echo "Checking for GNU Make:  " | tee -a $logfile
fi


if [ "$arch" = "macosx" ]; then
   if [ `sw_vers | sed -n 's/ProductVersion://p' | cut -d . -f 2` -ge 5 ]; then
      if `sysctl machdep.cpu.extfeatures | grep "64" > /dev/null  2>&1` ; then
         arch=macosx64
         platform=macosx
         PLATFORM=$platform
         system=64bit
         MAKE_command=make
	 checklib64="yes" 
      fi
   fi
fi


#------------------------------------------------------------------
#Check if the required programs are already installed on the system is_in_path patch

# taken from ROOT configure to solve the multi arch problem on ubuntu 11.




is_in_path dpkg-architecture
result=$?
if [ "$result" = "0" ];
 then
    install_dpkg=yes
 else
   echo "dpkg-architecture found in PATH" | tee -a $logfile
fi

debmultiarch=
if `$cwhich dpkg-architecture > /dev/null 2>&1` ; then
    if `dpkg-architecture -qDEB_HOST_MULTIARCH > /dev/null 2>&1` ; then
        echo  "Checking dpkg-architecture"
        debmultiarch=`dpkg-architecture -qDEB_HOST_MULTIARCH 2> /dev/null`
    fi
fi


is_in_path patch
result=$?
if [ "$result" = "0" ];
 then
    install_patch=yes
 else
   echo "patch found in PATH" | tee -a $logfile
fi
is_in_path wget
result=$?
if [ "$result" = "0" ];
 then
   install_wget=yes
 else
   
   echo "wget found in PATH" | tee -a $logfile
fi

is_in_path curl
result=$?
if [ "$result" = "0" ];
 then
   install_curl=yes
 else
   install_wget=no ## if curl exist no need to install wget
   echo "curl found in PATH" | tee -a $logfile
fi

is_in_path svn
result=$?
if [ "$result" = "0" ];
 then
   install_svn=yes
 else
   echo "Subversion client  found in PATH" | tee -a $logfile
fi

check_lib "libX11" "yes" "" \
    /usr/lib/$debmultiarch /usr/lib /usr/X11R6/lib /usr/lib/X11 /usr/openwin/lib \
    /usr/local/lib /usr/local/lib/X11 /usr/local/X11R6/lib \
    /usr/X11/lib /usr/lib/X11R5

if test "x$found_lib" = "x" ; then
    result "`basename $0`: libX11 (package libX11-devel (dev)) MUST be installed"
    
    if [ "$install_dpkg" = "yes" ]; 
    then 
    echo -e '\033[5m\033[31m dpkg-architecture not found in PATH, need to install dpkg-dev for ubuntu 11\033[0m ' | tee -a $logfile
    stop=no 
    fi    
   # exit 1
    stop=yes
fi

check_lib "libXpm" "yes" "$xpmlibdir"  \
    /usr/lib/$debmultiarch /usr/local/lib /usr/lib /usr/lib/X11 \
    /usr/local/lib/X11 /usr/X11R6/lib /usr/local/X11R6/lib \
    /usr/X11/lib
    
    
    

if test "x$found_lib" = "x" ; then
    result "`basename $0`: libXpm /libXpm-devel(dev) MUST be installed"
    #exit 1
    stop=yes
fi

check_lib "libXmu" "yes" "$xmulibdir"  \
    /usr/local/lib /usr/lib /usr/lib/X11 /usr/lib/$debmultiarch\
    /usr/local/lib/X11 /usr/X11R6/lib /usr/local/X11R6/lib \
    /usr/X11/lib

if test "x$found_lib" = "x" ; then
    result "`basename $0`: libXmu-dev MUST be installed"
    #exit 1
    stop=yes
fi


check_header "X11/Xlib.h" "" \
    /usr/include/$debmultiarch /usr/include /usr/X11R6/include /usr/include/X11 /usr/openwin/include \
    /usr/local/include /usr/local/include/X11 /usr/local/X11R6/include \
    /usr/X11/include /usr/include/X11R5

if test "x$found_dir" = "x" ; then
    result "`basename $0`: X11 headers (package x11-devel) MUST be installed"
    #exit 1
    stop=yes
fi

check_header "X11/Xft/Xft.h" "" \
   /usr/include/$debmultiarch /usr/include /usr/X11R6/include /usr/include/X11 /usr/openwin/include \
   /usr/local/include /usr/local/include/X11 /usr/local/X11R6/include \
   /usr/X11/include /usr/include/X11R5

if test "x$found_dir" = "x" ; then
   result "`basename $0`: Xft headers ( libxft-devel(dev) ) MUST be installed"
   #exit 1
   stop=yes
fi

check_header "X11/extensions/shape.h" "" \
   /usr/include /usr/X11R6/include /usr/include/X11 /usr/openwin/include \
   /usr/local/include /usr/local/include/X11 /usr/local/X11R6/include \
   /usr/X11/include /usr/include/X11R5

if test "x$found_dir" = "x" ; then
   result "`basename $0`: X11/extensions/shape.h header (xorg-x11-proto-devel or libxext-dev) MUST be installed"
   #exit 1
   stop=yes
fi


check_lib "libXft" "yes" "" \
    /usr/lib/$debmultiarch  /usr/local/lib /usr/lib /usr/lib/X11 \
    /usr/local/lib/X11 /usr/X11R6/lib /usr/local/X11R6/lib \
    /usr/X11/lib

if test "x$found_lib" = "x" ; then
    result "`basename $0`: libXft (libxft-devel) MUST be installed"
    #exit 1
    stop=yes
fi

check_lib "libXext" "yes" "" \
   /usr/lib/$debmultiarch  /usr/local/lib /usr/lib /usr/lib/X11 \
   /usr/local/lib/X11 /usr/X11R6/lib /usr/local/X11R6/lib \
   /usr/X11/lib

if test "x$found_lib" = "x" ; then
   result "`basename $0`: libXext (libXext-devel) MUST be installed"
   #exit 1
   stop=yes
fi




#------------------------------------------------------------------

if [ "$install_patch" = "yes" ]; 
  then 
   echo -e '\033[5m\033[31m patch not found in PATH, need to install it\033[0m ' | tee -a $logfile
   stop=yes 
fi

if [ "$install_wget" = "yes" -a  "$install_curl" = "yes" ]; 
   then 
     echo -e '\033[5m\033[31m neither wget nor curl found in PATH, need to install one of them \033[0m ' | tee -a $logfile
     if [ "$check" = "1" -a "$geant4_data_files" = "yes" ];
     then
         stop=yes
     fi
fi
if [ "$install_svn" = "yes" ]; 
  then 
   echo -e '\033[5m\033[31m SVN not found in PATH, it is recomanded to install it\033[0m ' | tee -a $logfile
fi

if [ "$stop" = "yes" ]; 
  then 
   echo -e '\033[5m\033[31m missing packages .............stop installation\033[0m ' | tee -a $logfile
   exit 1
fi


#------------------------------------------------------------------
#   taken from the ROOT configure
### echo %%% OpenGL Support - Third party libraries
#
# (see mesa3d.org)
#

    # Check for OpenGL compatible include and library
    openglincdirs="$OPENGL $OPENGL/include \
        /usr/include /usr/include/X11 /usr/X11/include \
        /usr/X11R6/include /usr/local/include/X11 \
        /usr/local/X11R6/include /usr/local/include \
        /usr/include/Mesa /usr/local/include/Mesa /usr/Mesa/include \
        /usr/local/Mesa/include /usr/Mesa /usr/local/Mesa /opt/Mesa \
        /opt/Mesa/include /opt/graphics/OpenGL/include"
    check_header "GL/gl.h" "$openglincdir" $openglincdirs
    openglinc=$found_hdr
    openglincdir=$found_dir

    opengllibdirs="$OPENGL $OPENGL/lib /usr/lib /usr/local/lib /usr/lib/X11 /usr/lib/$debmultiarch\
        /usr/X11R6/lib /usr/local/lib/X11 /usr/local/X11R6/lib \
        /usr/X11/lib /usr/lib/Mesa /usr/local/lib/Mesa /usr/Mesa/lib \
        /usr/local/Mesa/lib /usr/Mesa /usr/local/Mesa /opt/Mesa \
        /opt/Mesa/lib /opt/graphics/OpenGL/lib /usr/lib64"

    keep=$opengllibdir
    check_lib "libGL libMesaGL" "$enable_shared" \
        "$opengllibdir" $opengllibdirs
    opengllib=$found_lib
    opengllibdir=$found_dir

    # Mac OS X 10.5.0 problem
    if test "x$platform" = "xmacosx"; then
       if test ! "x$macosx105" = "x"; then
          opengllib="-dylib_file /usr/X11R6/lib/libGL.dylib:/usr/X11R6/lib/libGL.dylib"
       fi
    fi

    check_lib "libGLU libMesaGLU" "$enable_shared" \
        "$keep" $opengllibdirs
    openglulib=$found_lib
    openglulibdir=$found_dir

    if test "x$openglincdir" = "x" || \
       test "x$opengllib" = "x" || \
       test "x$openglulib" = "x" ; then
		if [ "$build_for_grid" = "yes" ];
		then
		  echo -e '\033[5m\033[31m Missing packages .............OpenGL is not installed in this system \033[0m' | tee -a $logfile
		  echo -e '\033[5m\033[31m As we are on Grid installation will continue \033[0m ' | tee -a $logfile
		else
		  echo -e '\033[5m\033[31m Missing packages .............OpenGL is not installed in this system\033[0m ' | tee -a $logfile
                  exit 1
                fi
    else
	     echo -e  'OpenGL found on this system' | tee -a $logfile	
    fi





#------------------------------------------------------------------


return 1

