#!/bin/bash

clear
echo
echo "Which compiler you want to use to compile the external packages?"
PS3='Please enter a choice from the above menu: '

select CHOICE in "GCC (Linux, Solaris and Mac OSX)" "Intel Compiler (Linux)" "CC (Solaris)" Quit
do
  case "$CHOICE" in
               Quit) exit			
                     ;;
              "GCC (Linux, Solaris and Mac OSX)") 
                     compiler=gcc
                     break
                     ;;
   "Intel Compiler (Linux)") 
                     compiler=intel
                     break
                     ;;
                "CC (Solaris)") 
                     compiler=CC
                     break
                     ;;
                 "") echo This value is not valid. Hit Enter to see menu again!
                     continue
                     ;;
   esac
done

clear
echo
echo "Do you want to compile the external packages with or without debug"
echo "information or with optimization?"
PS3='Please enter a choice from the above menu: '

select CHOICE in "No Debug Info" "Debug Info" "Optimize" Quit
do
  case "$CHOICE" in
              Quit) exit			
                    ;;
   "No Debug Info") debug=no
                    optimize=no
                    break
                    ;;
      "Debug Info") debug=yes
                    optimize=no
                    break
                    ;;
        "Optimize") debug=no
                    optimize=yes
                    break
                    ;;
                "") echo This value is not valid. Hit Enter to see menu again!
                    continue
                    ;;
   esac
done

clear
echo
echo "Would you like to install the additionally available data files"
echo "the GEANT4 package?"
echo "To do so you need either a internet conection (Internet) or you"
echo "have to provide the files in the transport subdirectory (Directory)."
PS3='Please enter a choice from the above menu: '

select CHOICE in "Don't install" "Internet" "Directory" Quit
do
  case "$CHOICE" in
              Quit) exit			
                    ;;
   "Don't install") geant4_data_files=no 
		    geant4_get_data=no   
                    break
                    ;;
      "Internet")   geant4_data_files=yes
                    geant4_get_data=yes   
                    break
                    ;;
       "Directory") geant4_data_files=yes 
                    geant4_get_data=no   
                    break
                    ;;
                "") echo This value is not valid. Hit Enter to see menu again!
                    continue
                    ;;
   esac
done

clear
echo
echo "Would you like to install all binaries, libraries etc. to a dedicated directory."
echo "The default is up to now 'No' which means that all created files will be in the"
echo "source directories."
PS3='Please enter a choice from the above menu: '

select CHOICE in "No" "Yes" Quit
do
  case "$CHOICE" in
              Quit) exit
                    ;;
              "No") make_install=no
                    break
                    ;;
             "Yes") make_install=yes
                    break
                    ;;
               "" ) echo This value is not valid. Hit Enter to see menu again!
                    continue
                    ;;
  esac
done

if [ "$make_install" = "yes" ]; then 
  question=true
  writable_dir=true
  while $question; do
    clear
    if ! $writable_dir; then
      echo "You don't have write permissions for $SIMPATH_INSTALL"
    fi  
    echo 'Please enter the full path of the installation directory'     
    read SIMPATH_INSTALL
    clear
    # expand variables, which could be in the filepath. A example is if $PWD is in the path
    eval SIMPATH_INSTALL=$SIMPATH_INSTALL
    echo "Is $SIMPATH_INSTALL the correct path?"
    PS3='Please enter a choice from the above menu: '

    select CHOICE in "No" "Yes" Quit                            
    do
      case "$CHOICE" in
                  Quit) exit
                        ;;
                  "No") question=true
                        break
                        ;;
                 "Yes") question=false
                        break
                        ;;
                   "" ) echo This value is not valid. Hit Enter to see menu again!
                        continue
                        ;;
      esac
    done
    #check if the user can write to the installation path
    mkdir -p $SIMPATH_INSTALL
    if [ $? -ne 0 ]; then
      question=true
      writable_dir=false
    fi  
  done                                                                                                                                                                                                                                       
fi     

                                                       