//
//  FairSimpletrackerGeo.cxx
//  
//
//  Created by Kunnawalkam Raghav on 2/25/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

#include "FairSimpletrackerGeo.h"
#include "FairGeoNode.h"

ClassImp(FairSimpletrackerGeo)

// -----   Default constructor   -------------------------------------------
FairSimpletrackerGeo::FairSimpletrackerGeo()
: FairGeoSet()
{
    // Constructor
    fName="simpletracker";
    maxSectors=0;
    maxModules=10;
}

// -------------------------------------------------------------------------

const char* FairSimpletrackerGeo::getModuleName(Int_t m)
{
    /** Returns the module name of FairSimpletracker number m
     Setting MyDet here means that all modules names in the
     ASCII file should start with FairSimpletracker otherwise they will
     not be constructed
     */
    sprintf(modName,"simpletracker%i",m+1);
    return modName;
}

const char* FairSimpletrackerGeo::getEleName(Int_t m)
{
    /** Returns the element name of Det number m */
    sprintf(eleName,"simpletracker%i",m+1);
    return eleName;
}

