//
//  FairSimpletrackerGeoPar.h
//  
//
//  Created by Kunnawalkam Raghav on 2/25/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

#ifndef CBMSIMPLETRACKERGEOPAR_H
#define CBMSIMPLETRACKERGEOPAR_H

#include "FairParGenericSet.h"

class TObjArray;
class FairParamList;

class FairSimpletrackerGeoPar       : public FairParGenericSet
{
public:
    
    /** List of FairGeoNodes for sensitive  volumes */
    TObjArray*      fGeoSensNodes;
    
    /** List of FairGeoNodes for sensitive  volumes */
    TObjArray*      fGeoPassNodes;
    
    FairSimpletrackerGeoPar(const char* name="FairSimpletrackerGeoPar",
                         const char* title="FairSimpletracker Geometry Parameters",
                         const char* context="TestDefaultContext");
    ~FairSimpletrackerGeoPar(void);
    void clear(void);
    void putParams(FairParamList*);
    Bool_t getParams(FairParamList*);
    TObjArray* GetGeoSensitiveNodes() {return fGeoSensNodes;}
    TObjArray* GetGeoPassiveNodes()   {return fGeoPassNodes;}
    
private:
    FairSimpletrackerGeoPar(const FairSimpletrackerGeoPar&);
    FairSimpletrackerGeoPar& operator=(const FairSimpletrackerGeoPar&);
    
    ClassDef(FairSimpletrackerGeoPar,1)
};

#endif

