//
//  FairSimpletrackerGeoPar.cxx
//  
//
//  Created by Kunnawalkam Raghav on 2/25/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

#include "FairSimpletrackerGeoPar.h"

#include "FairParamList.h"

#include "TObjArray.h"

#include <iostream>

ClassImp(FairSimpletrackerGeoPar)

FairSimpletrackerGeoPar ::FairSimpletrackerGeoPar(const char* name,
                                            const char* title,
                                            const char* context)
: FairParGenericSet(name,title,context),
fGeoSensNodes(new TObjArray()),
fGeoPassNodes(new TObjArray())
{
}

FairSimpletrackerGeoPar::~FairSimpletrackerGeoPar(void)
{
}

void FairSimpletrackerGeoPar::clear(void)
{
    if(fGeoSensNodes) { delete fGeoSensNodes; }
    if(fGeoPassNodes) { delete fGeoPassNodes; }
}

void FairSimpletrackerGeoPar::putParams(FairParamList* l)
{
    if (!l) { return; }
    l->addObject("FairGeoNodes Sensitive List", fGeoSensNodes);
    l->addObject("FairGeoNodes Passive List", fGeoPassNodes);
}

Bool_t FairSimpletrackerGeoPar::getParams(FairParamList* l)
{
    if (!l) { return kFALSE; }
    if (!l->fillObject("FairGeoNodes Sensitive List", fGeoSensNodes)) { return kFALSE; }
    if (!l->fillObject("FairGeoNodes Passive List", fGeoPassNodes)) { return kFALSE; }
    return kTRUE;
}
