//
//  eventDisplay.C
//  
//
//  Created by Kunnawalkam Raghav on 2/25/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

eventDisplay()
{
    // Load basic libraries
    TString dir = gSystem->Getenv("VMCWORKDIR");
    TString tut_configdir = dir + "/example/gconfig";
    gSystem->Setenv("CONFIG_DIR",tut_configdir.Data());
    gROOT->LoadMacro("$CONFIG_DIR/basiclibs.C");
    basiclibs();
    gSystem->Load("libFairTools");
    gSystem->Load("libGeoBase");
    cout << "before libparbase"<< endl;
    gSystem->Load("libParBase");
    cout << "hi"<< endl;
    gSystem->Load("libBase");
    gSystem->Load("libGen");
    gSystem->Load("libPassive");
    gSystem->Load("libFairSimpletracker");
    gSystem->Load("libFairDircDet");
    gSystem->Load("libFairEmlfDet");
    gSystem->Load("libEve");
    gSystem->Load("libEventDisplay");
    cout << "end of loading libraries"<< endl;
    
    
    // -----   Reconstruction run   -------------------------------------------
    FairRunAna *fRun= new FairRunAna();
    fRun->SetInputFile("data/simpletracker.mc.root");
    
    fRun->SetOutputFile("data/test.root");
    
    // -----  Parameter database   --------------------------------------------
    FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
    
    FairParRootFileIo* parIo1 = new FairParRootFileIo();
    parIo1->open("data/params.root");
    rtdb->setFirstInput(parIo1);
    
    // Create Event Display object
    FairEventManager *fMan= new FairEventManager();
    
	// Set desired colors to known volumes
	// useful for consistency, because by default 
    // your volumes are all grey, or randomly colored
    //fMan->ColorizeVolumes(kTRUE);
  
    /*
    fMan->AddColorAssociation("tpc01gas", kWhite);
    fMan->AddColorAssociation("hcal", kGreen);
    fMan->AddColorAssociation("emlf", kCyan);
    fMan->AddColorAssociation("sitt", kOrange);
    fMan->AddColorAssociation("trs", kOrange);
    fMan->AddColorAssociation("solenoid", kBlue);
    // i changed dirk to dirc. 
    fMan->AddColorAssociation("dirc", kPink);
    fMan->AddColorAssociation("htck", kMagenta);
    fMan->AddColorAssociation("dpm", kBlue);
     */
    
	// Set semitransparent volumes, for ease of 
	// track/hit location
   // fMan->SetVolumeTransparency((Char_t)50);
    
	// Initialize objects, which should be displayed 
    FairMCTracks *Track =  new FairMCTracks ("Monte-Carlo Tracks");
    //FairMCPointDraw *SitPoint =   new FairMCPointDraw ("SitPoint", kRed, kFullSquare);
    //FairMCPointDraw *TrsPoint =   new FairMCPointDraw ("TrsPoint", kOrange, kFullSquare);
    //FairMCPointDraw *EmlfPoint =   new FairMCPointDraw ("EmlfPoint", 7, 7);
    //FairMCPointDraw *TpcPoint =   new FairMCPointDraw ("TpcPoint", 8, 22);
    
    fMan->AddTask(Track);
    //fMan->AddTask(SitPoint);
    //fMan->AddTask(TrsPoint);
    //fMan->AddTask(EmlfPoint);
    //fMan->AddTask(TpcPoint);
     
    
	// Start application
    fMan->Init();
    
}


