//
//  FairDircDetContFact.cxx
//  
//
//  Created by Kunnawalkam Raghav on 3/1/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

#include "FairDircDetContFact.h"

#include "FairDircDetGeoPar.h"

#include "FairRuntimeDb.h"

#include <iostream>

ClassImp(FairDircDetContFact)

static FairDircDetContFact gFairDircDetContFact;

FairDircDetContFact::FairDircDetContFact()
: FairContFact()
{
    /** Constructor (called when the library is loaded) */
    fName="FairDircDetContFact";
    fTitle="Factory for parameter containers in libFairDircDet";
    setAllContainers();
    FairRuntimeDb::instance()->addContFactory(this);
}

void FairDircDetContFact::setAllContainers()
{
    /** Creates the Container objects with all accepted
     contexts and adds them to
     the list of containers for the FairDircDet library.
     */
    
    FairContainer* p= new FairContainer("FairDircDetGeoPar",
                                        "FairDircDet Geometry Parameters",
                                        "TestDefaultContext");
    p->addContext("TestNonDefaultContext");
    
    containers->Add(p);
}

FairParSet* FairDircDetContFact::createContainer(FairContainer* c)
{
    /** Calls the constructor of the corresponding parameter container.
     For an actual context, which is not an empty string and not
     the default context
     of this container, the name is concatinated with the context.
     */
    const char* name=c->GetName();
    FairParSet* p=NULL;
    if (strcmp(name,"FairDircDetGeoPar")==0) {
        p=new FairDircDetGeoPar(c->getConcatName().Data(),
                                   c->GetTitle(),c->getContext());
    }
    return p;
}
