//
//  FairSimpletrackerContFact.cxx
//  
//
//  Created by Kunnawalkam Raghav on 2/25/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

#include "FairSimpletrackerContFact.h"

#include "FairSimpletrackerGeoPar.h"

#include "FairRuntimeDb.h"

#include <iostream>

ClassImp(FairSimpletrackerContFact)

static FairSimpletrackerContFact gFairSimpletrackerContFact;

FairSimpletrackerContFact::FairSimpletrackerContFact()
: FairContFact()
{
    /** Constructor (called when the library is loaded) */
    fName="FairSimpletrackerContFact";
    fTitle="Factory for parameter containers in libFairSimpletracker";
    setAllContainers();
    FairRuntimeDb::instance()->addContFactory(this);
}

void FairSimpletrackerContFact::setAllContainers()
{
    /** Creates the Container objects with all accepted
     contexts and adds them to
     the list of containers for the FairSimpletracker library.
     */
    
    FairContainer* p= new FairContainer("FairSimpletrackerGeoPar",
                                        "FairSimpletracker Geometry Parameters",
                                        "TestDefaultContext");
    p->addContext("TestNonDefaultContext");
    
    containers->Add(p);
}

FairParSet* FairSimpletrackerContFact::createContainer(FairContainer* c)
{
    /** Calls the constructor of the corresponding parameter container.
     For an actual context, which is not an empty string and not
     the default context
     of this container, the name is concatinated with the context.
     */
    const char* name=c->GetName();
    FairParSet* p=NULL;
    if (strcmp(name,"FairSimpletrackerGeoPar")==0) {
        p=new FairSimpletrackerGeoPar(c->getConcatName().Data(),
                                   c->GetTitle(),c->getContext());
    }
    return p;
}

