/* Generated by Together */

#include "FairTarget.h"
#include "FairGeoLoader.h"
#include "FairGeoInterface.h"
#include "FairGeoTarget.h"
#include "FairGeoRootBuilder.h"
#include "FairRuntimeDb.h"
#include "FairGeoPassivePar.h"
#include "TObjArray.h"
#include "FairRun.h"
#include "FairGeoVolume.h"
#include "FairGeoNode.h"

FairTarget::~FairTarget()
{
}
FairTarget::FairTarget()
  : FairModule("FairTarget", "")
{
}

FairTarget::FairTarget(const char* name,  const char* title)
  : FairModule(name ,title)
{
}
void FairTarget::ConstructGeometry()
{
  FairGeoLoader* loader=FairGeoLoader::Instance();
  FairGeoInterface* GeoInterface =loader->getGeoInterface();
  FairGeoTarget* MGeo=new FairGeoTarget();
  MGeo->setGeomFile(GetGeometryFileName());
  GeoInterface->addGeoModule(MGeo);
  Bool_t rc = GeoInterface->readSet(MGeo);
  if ( rc ) { MGeo->create(loader->getGeoBuilder()); }

  TList* volList = MGeo->getListOfVolumes();
  // store geo parameter
  FairRun* fRun = FairRun::Instance();
  FairRuntimeDb* rtdb= FairRun::Instance()->GetRuntimeDb();
  FairGeoPassivePar* par=(FairGeoPassivePar*)(rtdb->getContainer("FairGeoPassivePar"));
  TObjArray* fSensNodes = par->GetGeoSensitiveNodes();
  TObjArray* fPassNodes = par->GetGeoPassiveNodes();

  TListIter iter(volList);
  FairGeoNode* node   = NULL;
  FairGeoVolume* aVol=NULL;

  while( (node = (FairGeoNode*)iter.Next()) ) {
    aVol = dynamic_cast<FairGeoVolume*> ( node );
    if ( node->isSensitive()  ) {
      fSensNodes->AddLast( aVol );
    } else {
      fPassNodes->AddLast( aVol );
    }
  }
  ProcessNodes( volList );
  par->setChanged();
  par->setInputVersion(fRun->GetRunId(),1);

}
ClassImp(FairTarget)



