/* Generated by Together */

#include "FairMCApplication.h"
#include "FairCave.h"
#include "FairVolume.h"
#include "FairVolumeList.h"
#include "TGeoMCGeometry.h"
#include "TGeoManager.h"
#include "TGeoVolume.h"
#include "TGeoMedium.h"

#include "FairGeoLoader.h"
#include "FairGeoInterface.h"
#include "FairGeoCave.h"
#include "FairGeoRootBuilder.h"
#include "FairRuntimeDb.h"
#include "FairGeoPassivePar.h"
#include "TObjArray.h"
#include "FairGeoVolume.h"
#include "FairGeoNode.h"
#include "FairRun.h"


ClassImp(FairCave)
void FairCave::ConstructGeometry()
{
  FairGeoLoader* loader=FairGeoLoader::Instance();
  FairGeoInterface* GeoInterface =loader->getGeoInterface();
  FairGeoCave* MGeo=new FairGeoCave();
  MGeo->setGeomFile(GetGeometryFileName());
  GeoInterface->addGeoModule(MGeo);
  Bool_t rc = GeoInterface->readSet(MGeo);
  if ( rc ) { MGeo->create(loader->getGeoBuilder()); }

  TList* volList = MGeo->getListOfVolumes();
  // store geo parameter
  FairRun* fRun = FairRun::Instance();
  FairRuntimeDb* rtdb= FairRun::Instance()->GetRuntimeDb();
  FairGeoPassivePar* par=(FairGeoPassivePar*)(rtdb->getContainer("FairGeoPassivePar"));
  TObjArray* fSensNodes = par->GetGeoSensitiveNodes();
  TObjArray* fPassNodes = par->GetGeoPassiveNodes();

  TListIter iter(volList);
  FairGeoNode* node   = NULL;
  FairGeoVolume* aVol=NULL;

  while( (node = (FairGeoNode*)iter.Next()) ) {
    aVol = dynamic_cast<FairGeoVolume*> ( node );
    if ( node->isSensitive()  ) {
      fSensNodes->AddLast( aVol );
    } else {
      fPassNodes->AddLast( aVol );
    }
  }
  par->setChanged();
  par->setInputVersion(fRun->GetRunId(),1);

}
FairCave::FairCave()
{
}

FairCave::~FairCave()
{

}
FairCave::FairCave(const char* name,  const char* Title)
  : FairModule(name ,Title)
{
  world[0] = 0;
  world[1] = 0;
  world[2] = 0;
}
