//
//  FairDircDetPoint.h
//  
//
//  Created by Kunnawalkam Raghav on 3/1/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

#ifndef CBMFairDircDetPoint_h
#define CBMFairDircDetPoint_h

#include "FairMCPoint.h"

#include "TObject.h"
#include "TVector3.h"

class FairDircDetPoint : public FairMCPoint
{
    
public:
    
    /** Default constructor **/
    FairDircDetPoint();
    
    
    /** Constructor with arguments
     *@param trackID  Index of MCTrack
     *@param detID    Detector ID
     *@param pos      Ccoordinates at entrance to active volume [cm]
     *@param mom      Momentum of track at entrance [GeV]
     *@param tof      Time since event start [ns]
     *@param length   Track length since creation [cm]
     *@param eLoss    Energy deposit [GeV]
     **/
    FairDircDetPoint(Int_t trackID, Int_t detID, TVector3 pos, TVector3 mom,
                        Double_t tof, Double_t length, Double_t eLoss,
                        Double_t radius, Double_t phi, Double_t theta);
    
    
    
    
    /** Destructor **/
    virtual ~FairDircDetPoint();
    
    /** Output to screen **/
    virtual void Print(const Option_t* opt) const;
    
private:
    
    Double32_t fRadius, fPhi, fTheta;
    
    /** Copy constructor **/
    FairDircDetPoint(const FairDircDetPoint& point);
    FairDircDetPoint operator=(const FairDircDetPoint& point);
    
    ClassDef(FairDircDetPoint,1)
    
};


#endif
