//
//  FairDircDetGeoPar.h
//  
//
//  Created by Kunnawalkam Raghav on 3/1/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

#ifndef CBMFairDircDetGeoPar_h
#define CBMFairDircDetGeoPar_h


#include "FairParGenericSet.h"

class TObjArray;
class FairParamList;

class FairDircDetGeoPar       : public FairParGenericSet
{
public:
    
    /** List of FairGeoNodes for sensitive  volumes */
    TObjArray*      fGeoSensNodes;
    
    /** List of FairGeoNodes for sensitive  volumes */
    TObjArray*      fGeoPassNodes;
    
    FairDircDetGeoPar(const char* name="FairDircDetGeoPar",
                         const char* title="FairDircDet Geometry Parameters",
                         const char* context="TestDefaultContext");
    ~FairDircDetGeoPar(void);
    void clear(void);
    void putParams(FairParamList*);
    Bool_t getParams(FairParamList*);
    TObjArray* GetGeoSensitiveNodes() {return fGeoSensNodes;}
    TObjArray* GetGeoPassiveNodes()   {return fGeoPassNodes;}
    
private:
    FairDircDetGeoPar(const FairDircDetGeoPar&);
    FairDircDetGeoPar& operator=(const FairDircDetGeoPar&);
    
    ClassDef(FairDircDetGeoPar,1)
};


#endif
