//
//  FairDircDetGeo.h
//  
//
//  Created by Kunnawalkam Raghav on 3/1/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

#ifndef CBMFairDircDetGeo_h
#define CBMFairDircDetGeo_h

#include "FairGeoSet.h"

class  FairDircDetGeo : public FairGeoSet
{
    
protected:
    char modName[20];  // name of module
    char eleName[20];  // substring for elements in module
public:
    FairDircDetGeo();
    ~FairDircDetGeo() {}
    const char* getModuleName(Int_t);
    const char* getEleName(Int_t);
    inline Int_t getModNumInMod(const TString&);
    ClassDef(FairDircDetGeo,1)
};

inline Int_t FairDircDetGeo::getModNumInMod(const TString& name)
{
    /** returns the module index from module name
     ?? in name[??] has to be the length of the detector name in the
     .geo file. For example if all nodes in this file starts with
     newdetector ?? has to be 11.
     */
    return (Int_t)(name[10]-'0')-1; //
}

#endif
