//
//  FairDpm.cxx
//  
//
//  Created by Kunnawalkam Raghav on 3/1/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

FairDpm::~FairDpm()
{
}

FairDpm::FairDpm()
: FairModule("FairDpm", "")
{
}

FairDpm::FairDpm(const char* name, const char* title)
: FairModule(name ,title)
{
}

void FairDpm::ConstructGeometry()
{
    
    TString fileName=GetGeometryFileName();
    if (fileName.EndsWith(".geo")) {
        ConstructASCIIGeometry();
    } else if(fileName.EndsWith(".root")) {
        ConstructRootGeometry();
    } else {
        std::cout<< "Geometry format not supported " <<std::endl;
    }
}

Bool_t FairDpm::CheckIfSensitive(std::string name)
{
    // just to get rid of the warrning during run, not need this is a passive element!
    return kFALSE;
}

void FairDpm::ConstructASCIIGeometry()
{
    FairGeoLoader* loader=FairGeoLoader::Instance();
    FairGeoInterface* GeoInterface =loader->getGeoInterface();
    FairDpmGeo* MGeo=new FairDpmGeo();
    MGeo->setGeomFile(GetGeometryFileName());
    GeoInterface->addGeoModule(MGeo);
    Bool_t rc = GeoInterface->readSet(MGeo);
    if ( rc ) { MGeo->create(loader->getGeoBuilder()); }
    
    TList* volList = MGeo->getListOfVolumes();
    // store geo parameter
    FairRun* fRun = FairRun::Instance();
    FairRuntimeDb* rtdb= FairRun::Instance()->GetRuntimeDb();
    FairGeoPassivePar* par=(FairGeoPassivePar*)(rtdb->getContainer("FairGeoPassivePar"));
    TObjArray* fSensNodes = par->GetGeoSensitiveNodes();
    TObjArray* fPassNodes = par->GetGeoPassiveNodes();
    
    TListIter iter(volList);
    FairGeoNode* node   = NULL;
    FairGeoVolume* aVol=NULL;
    
    while( (node = (FairGeoNode*)iter.Next()) ) {
        aVol = dynamic_cast<FairGeoVolume*> ( node );
        if ( node->isSensitive()  ) {
            fSensNodes->AddLast( aVol );
        } else {
            fPassNodes->AddLast( aVol );
        }
    }
    ProcessNodes( volList );
    par->setChanged();
    par->setInputVersion(fRun->GetRunId(),1);
}


ClassImp(FairDpm)

