//
//  FairSimpletrackerPoint.h
//  
//
//  Created by Kunnawalkam Raghav on 2/25/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

#ifndef CBMSIMPLETRACKERPOINT_H
#define CBMSIMPLETRACKERPOINT_H 1


#include "FairMCPoint.h"

#include "TObject.h"
#include "TVector3.h"

class FairSimpletrackerPoint : public FairMCPoint
{
    
public:
    
    /** Default constructor **/
    FairSimpletrackerPoint();
    
    
    /** Constructor with arguments
     *@param trackID  Index of MCTrack
     *@param detID    Detector ID
     *@param pos      Ccoordinates at entrance to active volume [cm]
     *@param mom      Momentum of track at entrance [GeV]
     *@param tof      Time since event start [ns]
     *@param length   Track length since creation [cm]
     *@param eLoss    Energy deposit [GeV]
     **/
    FairSimpletrackerPoint(Int_t trackID, Int_t detID, TVector3 pos, TVector3 mom,
                        Double_t tof, Double_t length, Double_t eLoss,
                        Double_t radius, Double_t phi, Double_t theta);
    
    
    
    
    /** Destructor **/
    virtual ~FairSimpletrackerPoint();
    
    /** Output to screen **/
    virtual void Print(const Option_t* opt) const;
    
private:
    
    Double32_t fRadius, fPhi, fTheta;
    
    /** Copy constructor **/
    FairSimpletrackerPoint(const FairSimpletrackerPoint& point);
    FairSimpletrackerPoint operator=(const FairSimpletrackerPoint& point);
    
    ClassDef(FairSimpletrackerPoint,1)
    
};

#endif

