//
//  FairSimpletrackerGeo.h
//  
//
//  Created by Kunnawalkam Raghav on 2/25/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

#ifndef CBMSIMPLETRACKERGEO_H
#define CBMSIMPLETRACKERGEO_H

#include "FairGeoSet.h"

class  FairSimpletrackerGeo : public FairGeoSet
{
    
protected:
    char modName[20];  // name of module
    char eleName[20];  // substring for elements in module
public:
    FairSimpletrackerGeo();
    ~FairSimpletrackerGeo() {}
    const char* getModuleName(Int_t);
    const char* getEleName(Int_t);
    inline Int_t getModNumInMod(const TString&);
    ClassDef(FairSimpletrackerGeo,1)
};

inline Int_t FairSimpletrackerGeo::getModNumInMod(const TString& name)
{
    /** returns the module index from module name
     ?? in name[??] has to be the length of the detector name in the
     .geo file. For example if all nodes in this file starts with
     newdetector ?? has to be 11.
     */
    return (Int_t)(name[10]-'0')-1; //
}

#endif

