//
//  run_simpletracker.C

//  Created by Kunnawalkam Raghav on 2/25/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.



void run_simpletracker(Int_t nEvents = 1)
{
    TString dir = gSystem->Getenv("VMCWORKDIR");
    TString tutdir = dir + "/example/simpletracker/macros";

    TString tut_geomdir = dir + "/example/geometry";
    gSystem->Setenv("GEOMPATH",tut_geomdir.Data());

    TString tut_configdir = dir + "/example/gconfig";
    gSystem->Setenv("CONFIG_DIR",tut_configdir.Data());

    TString outDir  = "data";
    TString outFile = outDir + "/simpletracker.mc.root";
    TString parFile = outDir + "/params.root";

    TString basicLibs = tut_configdir +"/basiclibs.C";

    // In general, the following parts need not be touched
    // ========================================================================

    // ----    Debug option   -------------------------------------------------
    gDebug = 0;
    // ------------------------------------------------------------------------

    // -----   Timer   --------------------------------------------------------
    TStopwatch timer;
    timer.Start();
    // ------------------------------------------------------------------------

    // ----  Load libraries   -------------------------------------------------
    //gROOT->LoadMacro("$CONFIG_DIR/basiclibs.C");
    //  gROOT->LoadMacro(basicLibs);
    //  basiclibs();
    gSystem->Load("libGeom");
    gSystem->Load("libGeomPainter");


    gSystem->Load("libPhysics");
    gSystem->Load("libEG"); 
    gSystem->Load("libVMC");
    gSystem->Load("libEGPythia6");
    gSystem->Load("libPythia6");  
    gSystem->Load("libPluto");  
    gSystem->Load("libMinuit");
    gSystem->Load("libTree"); 

    gSystem->Load("libRIO");
    gSystem->Load("libGeom");
    gSystem->Load("libGeomPainter");
    gSystem->Load("libVMC");
    gSystem->Load("libEG");
    gSystem->Load("libEGPythia6");
    gSystem->Load("libPythia6");  
    gSystem->Load("libPhysics");
    gSystem->Load("libNet");  
    gSystem->Load("libTree"); 
    gSystem->Load("libMinuit");
    gSystem->Load("libMathMore");
    gSystem->Load("libFairTools");
    gSystem->Load("libGeoBase");
    gSystem->Load("libParBase");
    gSystem->Load("libBase");
    gSystem->Load("libMCStack");
    gSystem->Load("libGen");
    gSystem->Load("libPassive");
    gSystem->Load("libFairSimpletracker");
    gSystem->Load("libFairDircDet");
    gSystem->Load("libFairEmlfDet");
    gSystem->Load("libFairFgtDet");
    gSystem->Load("libFairHcalDet");
    gSystem->Load("libFairHtckDet");
    gSystem->Load("libFairSitDet");
    gSystem->Load("libFairTpcDet");
    gSystem->Load("libFairTrsDet");
    // ------------------------------------------------------------------------

    // -----   Create simulation run   ----------------------------------------
    FairRunSim* run = new FairRunSim();
    run->SetName("TGeant3");              // Transport engine
    run->SetOutputFile(outFile);          // Output file
    FairRuntimeDb* rtdb = run->GetRuntimeDb();
    // ------------------------------------------------------------------------


    // ----- Create media -----------------------------------------------------

    run->SetMaterials("media.geo");//materials
    //-----------------------------------------------------------------------


    // ----- Create geometry -------------------------------------

    // Modules
    
    FairModule* Cave = new FairCave("CAVE");
    Cave->SetGeometryFileName("cave.geo"); 
    run->AddModule(Cave);

//    FairModule* Pipe = new FairPipe("PIPE");
//    Pipe->SetGeometryFileName("pipe.geo"); 
//    run->AddModule(Pipe);

    FairModule* Magnet = new FairMagnet("MAGNET");
    Magnet->SetGeometryFileName("magnet.geo"); 
    run->AddModule(Magnet);
    
//   FairModule* DipoleMagnet = new FairDpm("DipoleMagnet");
//    DipoleMagnet->SetGeometryFileName("dpm.gep");
//    run->AddModule(DipoleMagnet);

 
    // Detectors

    
    
    FairDetector* Dirc = new FairDircDet("DIRC", kFALSE);
    Dirc->SetGeometryFileName("dirc.geo"); 
    run->AddModule(Dirc);
 
      FairDetector* Emlf = new EmlfDet("EMLF", kFALSE);
    Emlf->SetGeometryFileName("emlf.geo"); 
    run->AddModule(Emlf);
  
    FairModule* Dpm = new FairDpm("DPM");
    Dpm->SetGeometryFileName("dpm.geo"); 
    run->AddModule(Dpm);

    FairDetector* Tpc = new FairTpcDet("TPC", kTRUE);
    Tpc->SetGeometryFileName("tpc.geo"); 
    //  Tpc->SetGeometryFileName("tpc_layered.geo"); 
    run->AddModule(Tpc);

    FairDetector* Hcal = new HcalDet("HCAL", kTRUE);
    Hcal->SetGeometryFileName("hcal.geo"); 
    run->AddModule(Hcal);

    FairDetector* Sit = new SitDet("SIT", kTRUE);
    Sit->SetGeometryFileName("sit.geo"); 
    run->AddModule(Sit);

    FairDetector* Trs = new TrsDet("TRS", kTRUE);
    Trs->SetGeometryFileName("trs.geo"); 
    run->AddModule(Trs);

    FairDetector* Htck = new HtckDet("HTCK", kTRUE);
    Htck->SetGeometryFileName("htck.geo"); 
    run->AddModule(Htck);

    FairDetector* Fgt = new FgtDet("FGT", kTRUE);
    Fgt->SetGeometryFileName("fgt.geo"); 
    run->AddModule(Fgt)

  

    // -----   Create PrimaryGenerator   --------------------------------------
 //  FairPrimaryGenerator* primGen = new FairPrimaryGenerator();
  //   run->SetGenerator(primGen);


    // Ion Generator
   // FairIonGenerator *fIongen= new FairIonGenerator(1, 1, 1, 1, 0., 0., 1./20, 0., 0., -1.); 
  // primGen->AddGenerator(fIongen);

    /*
    FairBoxGenerator* boxGen1 = new FairBoxGenerator(2212, 1);
    boxGen1->SetPRange(.005,.005);
    boxGen1->SetPhiRange(0.,0.);
    boxGen1->SetThetaRange(0.,0.);
    boxGen1->SetXYZ(0.,0.,-3.);
    boxGen1->Init();
    primGen->AddGenerator(boxGen1);
    */

    // ------------------------------------------------------------------------

  //  run->SetStoreTraj(kTRUE);

    // -----   Run initialisation   -------------------------------------------

    run->Init();    

    
    // ------------------------------------------------------------------------

    // Set cuts for storing the trajectories.
    // Switch this on only if trajectories are stored.
    // Choose this cuts according to your needs, but be aware
    // that the file size of the output file depends on these cuts

  /*  
    FairTrajFilter* trajFilter = FairTrajFilter::Instance();
  //  trajFilter->SetStepSizeCut(0.01); // 1 cm
    // trajFilter->SetVertexCut(-2000., -2000., 4., 2000., 2000., 100.);
    // trajFilter->SetMomentumCutP(10e-3); // p_lab > 10 MeV
    // trajFilter->SetEnergyCut(0., 1.02); // 0 < Etot < 1.04 GeV
    trajFilter->SetStorePrimaries(kTRUE);
    trajFilter->SetStoreSecondaries(kTRUE);
    // ------------------------------------------------------------------------
*/
    // -----   Runtime database   ---------------------------------------------

  
    Bool_t kParameterMerged = kTRUE;
    FairParRootFileIo* parOut = new FairParRootFileIo(kParameterMerged);
    //  FairParAsciiFileIo* parOut = new FairParAsciiFileIo();
    parOut->open(parFile.Data());
    rtdb->setOutput(parOut);
    rtdb->saveOutput();
    rtdb->print();
    // ------------------------------------------------------------------------

   
    // -----   Start run   ----------------------------------------------------

    run->Run(nEvents);
    // ------------------------------------------------------------------------
    run->CreateGeometryFile("data/geofile_full.root");

    // -----   Finish   -------------------------------------------------------
    timer.Stop();
    Double_t rtime = timer.RealTime();
    Double_t ctime = timer.CpuTime();
    cout << endl << endl;
    cout << "Macro finished succesfully." << endl;
    cout << "Output file is "    << outFile << endl;
    cout << "Parameter file is " << parFile << endl;
    cout << "Real time " << rtime << " s, CPU time " << ctime 
    << "s" << endl << endl;
    // ------------------------------------------------------------------------
}
