//
//  FairDircDetGeoPar.cxx
//  
//
//  Created by Kunnawalkam Raghav on 3/1/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

#include "FairDircDetGeoPar.h"

#include "FairParamList.h"

#include "TObjArray.h"

#include <iostream>

ClassImp(FairDircDetGeoPar)

FairDircDetGeoPar ::FairDircDetGeoPar(const char* name,
                                            const char* title,
                                            const char* context)
: FairParGenericSet(name,title,context),
fGeoSensNodes(new TObjArray()),
fGeoPassNodes(new TObjArray())
{
}

FairDircDetGeoPar::~FairDircDetGeoPar(void)
{
}

void FairDircDetGeoPar::clear(void)
{
    if(fGeoSensNodes) { delete fGeoSensNodes; }
    if(fGeoPassNodes) { delete fGeoPassNodes; }
}

void FairDircDetGeoPar::putParams(FairParamList* l)
{
    if (!l) { return; }
    l->addObject("FairGeoNodes Sensitive List", fGeoSensNodes);
    l->addObject("FairGeoNodes Passive List", fGeoPassNodes);
}

Bool_t FairDircDetGeoPar::getParams(FairParamList* l)
{
    if (!l) { return kFALSE; }
    if (!l->fillObject("FairGeoNodes Sensitive List", fGeoSensNodes)) { return kFALSE; }
    if (!l->fillObject("FairGeoNodes Passive List", fGeoPassNodes)) { return kFALSE; }
    return kTRUE;
}
