//
//  FairDircDetGeo.cxx
//  
//
//  Created by Kunnawalkam Raghav on 3/1/12.
//  Copyright (c) 2012 Stony Brook University. All rights reserved.
//

#include "FairDircDetGeo.h"
#include "FairGeoNode.h"

ClassImp(FairDircDetGeo)

// -----   Default constructor   -------------------------------------------
FairDircDetGeo::FairDircDetGeo()
: FairGeoSet()
{
    // Constructor
    fName="rutherford";
    maxSectors=0;
    maxModules=10;
}

// -------------------------------------------------------------------------

const char* FairDircDetGeo::getModuleName(Int_t m)
{
    /** Returns the module name of FairDircDet number m
     Setting MyDet here means that all modules names in the
     ASCII file should start with FairDircDet otherwise they will
     not be constructed
     */
    sprintf(modName,"rutherford%i",m+1);
    return modName;
}

const char* FairDircDetGeo::getEleName(Int_t m)
{
    /** Returns the element name of Det number m */
    sprintf(eleName,"rutherford%i",m+1);
    return eleName;
}
