#ifndef token_ports_H
#define token_ports_H

#include <systemc/communication/sc_port.h>
#include <systemc/communication/sc_event_finder.h>
#include "TTokens.h"
#include "TToken_interfaces.h"

// Output port 

class TTokenOut : public sc_port<TToken_write_interface,0> {
   public:
      TTokenOut() : sc_port<TToken_write_interface,0>() {}

      ~TTokenOut() {}
     
      bool canWrite() const { return (*this)->canWrite(); }
      
      bool write(const TToken* token) {
         return (*this)->write(token);
      }
     
      bool write(const TToken* token, double time) {
         return (*this)->write(token, time);
      }
      
      sc_event_finder& token_write() {
         return *new sc_event_finder_t<TToken_write_interface>(*this, &TToken_write_interface::token_write);
      }
};

// Input port

class TTokenInp : public sc_port<TToken_read_interface,0> {
   public:
      TTokenInp() : sc_port<TToken_read_interface,0>() {}

      ~TTokenInp() {}
      
      bool canRead() const {
         return (*this)->canRead(); 
      }
      
      virtual const TToken* read() {
         return (*this)->read();
      }
      
      sc_event_finder& token_arrived() {
         return *new sc_event_finder_t<TToken_read_interface>(*this, &TToken_read_interface::token_arrived);
     }
};


#endif
