#ifndef token_interfaces_H
#define token_interfaces_H

#include <systemc/communication/sc_interface.h>
#include "TTokens.h"

class TToken_write_interface : virtual public sc_interface {
   public:
      virtual bool canWrite() const = 0;
      virtual bool write(const TToken*) = 0;
      virtual bool write(const TToken*, double) = 0;
      virtual const sc_event& token_write() const = 0;
};

class TToken_read_interface : virtual public sc_interface {
   public:
      virtual bool canRead() const = 0;
      virtual const TToken* read() = 0;
      virtual const sc_event& token_arrived() const = 0;
};

#endif

