#include "TToken_channel.h"

long int TToken_channel::fNumTransactions = 0;

TToken_channel::TToken_channel(sc_module_name iname, double time) : 
   TToken_write_interface(), 
   TToken_read_interface(), 
   sc_module(iname),
   fxTransferTime(time),
   fToken(0) {
}

bool TToken_channel::write(const TToken* token) { 
   return write(token, 0);
}

bool TToken_channel::write(const TToken* token, double time) {
   if (fToken!=0) return false;
   fToken = token; 
   evTransfer.notify(sc_time(fxTransferTime+time, SC_SEC));
   return true;
}

const TToken* TToken_channel::read() { 
   const TToken* buf = fToken; 
   fToken = 0; 
   fNumTransactions++;
   evWrite.notify(SC_ZERO_TIME);
   return buf; 
}
