#include <time.h>

#include <systemc.h>

#include "TGenerator.h"
#include "TTimedDelay.h"
#include "TDiscard.h"
#include "TToken_channel.h"

sc_string mname_buffer;

const char* mname(const char* base, int num) {
   mname_buffer = sc_string::to_string("%s_%d", base, num);
   return mname_buffer.c_str();
}

int sc_main(int argc, char* argv[]) {

   int numdelays = 10;
   
   int runtime = 10000;

   if (argc>1) numdelays = atoi(argv[1]);
   if (numdelays<=0) numdelays = 1;
   
   if (argc>2) runtime = atoi(argv[2]);
   if (runtime<10) runtime = 10;

   cout << "Create " << numdelays << " delay actors " << endl;
    
   TGenerator* generator = new TGenerator("Generator", 1.);
   
   //   TTimedDelay* delays[numdelays];
   TTimedDelay **delays = (TTimedDelay**)  malloc (sizeof(TTimedDelay*) * numdelays);

   for (int n=0;n<numdelays;n++)
     delays[n] = new TTimedDelay(mname("D",n), 0.999 - 0.1*n/numdelays);
   
   TDiscard* discard = new TDiscard("Discard");
   
   //   TToken_channel* chanels[numdelays+1];
   TToken_channel **chanels = (TToken_channel**)  malloc (sizeof(TToken_channel*) * 
	   (numdelays+1));

   for (int n=0;n<=numdelays;n++)
     chanels[n] = new TToken_channel(mname("C",n), 0.);

   generator->output(*chanels[0]);
   for (int n=0;n<numdelays;n++) {
     delays[n]->input(*chanels[n]);
     delays[n]->output(*chanels[n+1]);
   }
   
   discard->input(*chanels[numdelays]);
   
   cout << "Start " << endl; 
   
   time_t t1 = time(0);
   
   sc_start(runtime, SC_SEC);
   
   time_t t2 = time(0);
   
   cout << "Execute done in " << t2 - t1 << " sec " << endl;
   
   cout << "Number of transactions = " << TToken_channel::NumTransactions() << endl;
   if (t2-t1>0)
     cout << " Rate = " << TToken_channel::NumTransactions() * 1. / (t2-t1) << "  trans/sec" << endl;
   
   
   return 0;
}
