#ifndef token_channel_H
#define token_channel_H

/*
   Token based channel.
*/

#include <systemc/kernel/sc_module.h>

#include "TTokens.h"
#include "TToken_interfaces.h"

class TToken_channel : public TToken_write_interface, 
                       public TToken_read_interface,
                       public sc_module {
                      
   public:    
      // write interface implementation
      
      virtual bool canWrite() const { return fToken==0; };
      virtual bool write(const TToken*);
      virtual bool write(const TToken*, double);
      virtual const sc_event& token_write() const { return evWrite; }

      // read interface implementation
      
      virtual bool canRead() const { return fToken!=0; }
      virtual const TToken* read();
      virtual const sc_event& token_arrived() const { return evTransfer; }

      TToken_channel(sc_module_name iname, double time); 
      
      static long int NumTransactions() { return fNumTransactions; }
      
   protected: 
      sc_event evWrite, evTransfer;
      double fxTransferTime;
      const TToken* fToken;
      
      static long int fNumTransactions;
};


#endif


