#include "TTimedDelay.h"

TTimedDelay::TTimedDelay(sc_module_name _name, double delay) : 
  TActor(_name), fDelay(delay) {
   SC_METHOD(data_arrived);   
   sensitive << input.token_arrived();
   dont_initialize(); 
}

void TTimedDelay::data_arrived() {
   fireIfReady(); 
}

     
double TTimedDelay::fire() {
   if (input.canRead()) {
      const TToken* token = input.read();
      
      if (output.canWrite()) 
        output.write(token, fDelay);
      else {
        cout << "Kill token " << token->to_str() << endl;  
        delete token;  
      }
   }
   return -1;   
}

