#ifndef TActor_H
#define TActor_H

#include <systemc/kernel/sc_module.h>

class TActor : public sc_module {
   public:
      TActor(sc_module_name& _name, bool activate = false);
      
   protected:
      SC_HAS_PROCESS(TActor);
    
      void activateModule();
      
      void fireIfReady();
      
      virtual void end_of_elaboration() { initialize(); }
      
      // function, which should be implemented by user in derived classes

      virtual double fire();
      
      virtual void initialize();
    
   private:
      bool   fReady;
};


#endif

