# This script runs PandaRoot macros for the full Sim with
# TPC as Tracker
# usage: ./go_tpc.sh <nEvents>
# (06/2009 R. Kliemt)

# make data directory, if not there. all data file go there, makes them easier to move around
if [ ! -d "data" ]; then 
  mkdir data
fi

# reads number of events from first parameter
nEvts=0
if test "$1" != "" ; then 
  nEvts=$1
else
  echo "Usage: ./go_tpc.sh <nEvents>"
  exit
fi

# Protect Disk space from being flooded by messages
# -le : <= , -lt : < , etc. see "man test"
if [ $nEvts -le 50 ] ; then
  out1="data/1-sim.log"
  out2="data/2-digi.log"
  out3="data/3-reco.log"
  out4="data/4-kalman.log"
  out5="data/5-microwriter.log"
else 
  out1="/dev/null"
  out2="/dev/null"
  out3="/dev/null"
  out4="/dev/null"
  out5="/dev/null"
fi

# let's go
echo "Start PandaRoot Simulation with $nEvts events."
root -l -q run_sim_tpccombi_pgun.C\($nEvts,3122,1.0,-1\) &> $out1
echo "Start Digitization"
root -l -q run_digi_tpccombi.C\($nEvts\) &> $out2
echo "Start LHE Trackfinding and Prefit."
root -l -q run_reco_tpccombi.C\($nEvts\) &> $out3
echo "Start Kalman Filter (Trackfitting) and PID."
root -l -q run_kalman_tpc.C\($nEvts\) &> $out4
echo "Start an analysis macro (Rho)"
root -l ana.C\(\"data/fit_tpccombi.root\"\)
#root -l ananew.C\(\"data/fit_tpccombi.root\",$nEvts\)