void ananew(TString inFitFile="",int nevts=0)
{
  TStopwatch timer;
  timer.Start();
	
	gSystem->Load("libEGPythia6");  // needed for TDatabasePDG
  gROOT->Macro("$VMCWORKDIR/gconfig/rootlogon.C");
	gSystem->Load("libRho");
	gSystem->Load("libPid");
	gSystem->Load("libAnalysisTools");

  FairRunAna* fRun = new FairRunAna();

  TString parFile = "data/params_tpccombi.root";
  TString inSimuFile = "data/points_tpccombi.root";
  TString inDigiFile = "data/digi_tpccombi.root";
  TString inRecoFile = "data/reco_tpccombi.root";
  if(inFitFile=="") inFitFile = "data/fit_tpccombi.root";
  TString outFile = "data/dummy_evr_out.root";
  TString sysFile = gSystem->Getenv("VMCWORKDIR");
  fRun->SetInputFile(inSimuFile);
  //fRun->AddFriend(inDigiFile);
  //fRun->AddFriend(inRecoFile);
	fRun->AddFriend(inFitFile);
	fRun->SetOutputFile(outFile.Data());
//  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
//  FairParRootFileIo* parIO = new FairParRootFileIo();
//  parIO->open(parFile.Data());
//  rtdb->setFirstInput(parIO);
//  rtdb->setOutput(parIO);  
	fRun->Init();
	PndAnalysis* theAnalysis = new PndAnalysis();
		
  // to attach more files: evr.Add(fname2);evr.Add(fname3); ...
	
	TH1F *hMoml=new TH1F("momla","P(#Lambda)",100,0.0,5.0);
	TH1F *hMomlVtxfit=new TH1F("momlav","P(#LambdaVtxFit)",100,0.0,5.0);
	TH1F *hMompi=new TH1F("momppi","P(#pi)",200,-1.0,15.0);
	TH1F *hMomp=new TH1F("mompim","P(P)",200,-1.0,15.0);
  
  TH1F *hTheta=new TH1F("htheta","#theta(#Lambda)",200,0.,3.5);
	TH1F *hMass=new TH1F("mass","M(#Lambda)",200,0.0,6.0);
	TH1F *hMassVtxfit=new TH1F("massv","M(#LambdaVtxFit)",200,0.5,2.0);
	TH1F *hMassPion=new TH1F("masspi","M(#pi)",200,0.0,1.2);
	TH1F *hMassProton=new TH1F("massp","M(P)",200,0.0,1.2);
  TH1I *hCharge=new TH1I("charge","C(#Lambda)",5,-2,2);
	
	// the candidates lists we need
	TCandList pion, proton, lambda;
	
	// some mass selectors
  TPidMassSelector *lamMassSel=new TPidMassSelector("lam",1.116,0.05);
	TPidMassSelector *etaMassSel=new TPidMassSelector("eta",0.534,0.03);
	TPidMassSelector *pi0MassSel=new TPidMassSelector("pi0",0.130,0.03);
	TPidMassSelector *piMassSel=new TPidMassSelector("pi",0.130,0.03);
	
	if (nevts==0) nevts=theAnalysis.GetEntries();
	int i=0,j;
	
	// *************
	// this is the loop through the events ... as simple as this...
	// ****************
	while (theAnalysis->GetEvent() && i++<nevts)
	{
    // ask the event reader to fill the gamma candidates lists
		//evr.FillList(gam,"Neutral");
    theAnalysis->FillList(proton,"ProtonLoose");
    theAnalysis->FillList(pion,"PionLoose");
    
    for(int k=0;k<proton.GetLength();k++) {
      std::cout<<" Proton: "<<proton[k]<<std::endl;
    }
    for(int k=0;k<pion.GetLength();k++) {
      std::cout<<" Pion: "<<pion[k]<<std::endl;
    }
    
    lambda.Combine(proton, pion);
    
    // Do Vertex Fit. Thyis changes daughters, too!
		for (j=0;j<lambda.GetLength();++j) {
      hMoml->Fill(lambda[j].P()); 		
      hMass->Fill(lambda[j].Mass());
      PndVtxFitter fitter(lambda[j]);
      fitter.SetBeamConstraint(0);
      fitter.Fit();
      hMomlVtxfit->Fill(fitter.FittedCand(lambda[j])->P()); 		
      hMassVtxfit->Fill(fitter.FittedCand(lambda[j])->Mass());
      //vertex / distance?
      //    lambda[j]
    }
    
    // fill a histogram
		for (j=0;j<proton.GetLength();++j) {
      hMassProton->Fill(proton[j].Mass());
      hMomp->Fill(proton[j].P());
    }
		for (j=0;j<pion.GetLength();++j) {
      hMassPion->Fill(pion[j].Mass());
      hMompi->Fill(pion[j].P());
    }
    
    
    
    
		//pi.Select(piMassSel);
    
    
		// do the combinatorics and selection
		//pi0.Combine(gam,gam);
		//pi0.Select(pi0MassSel);
		
		//eta.Combine(gam,gam);
		//eta.Select(etaMassSel);
		
		// Combine now works with up to 5 lists
		// double counting and overlap when using the same list
		// more the once is handled properly
		//etac.Combine(eta, pi0, pi0); 
    
    
	}
	
	// ... and plot it
	TCanvas *c1=new TCanvas("c1","c1",800,600);
  c1->Divide(3,2);
	c1->cd(1); 
  hMomp->Draw();
	c1->cd(2); 
  hMompi->Draw();
  c1->cd(3); 
  hMass->Draw();
  hMass->Fit("gaus", "R", "", 1., 1.25);
  c1->Update();

  //
  
  c1->cd(4); 
  hMassVtxfit->SetLineColor(kRed);
  cout<<" FIT Lambda Mass"<<endl;
  hMassVtxfit->Fit("gaus", "R", "", 1., 1.25);
  hMassVtxfit->Draw();
  c1->Update();

  cout<<" FIT Lambda Momenta (should be 1.0 GeV)"<<endl;
  c1->cd(5);
  //  TF1* f1 = new TF1("myfuncgaus","gaus");
  hMoml->Fit("gaus", "R", "", 0.5, 1.5);
  hMoml->Draw();
  c1->Update();
  
  c1->cd(6);
  hMomlVtxfit->SetLineColor(kRed);
  hMomlVtxfit->Fit("gaus", "R", "", 0.1, 1.5);
  hMomlVtxfit->DrawCopy("");
  
	// now take the time...
  timer.Stop();
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  
  printf("RealTime=%f seconds, CpuTime=%f seconds\n",rtime,ctime);
}